/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.AliceMenuWithDelayedPopup;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.TypedTableModel;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.criterion.ExpressionIsAssignableToCriterion;
import edu.cmu.cs.stage3.util.Enumerable;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class PropertyCellEditor
implements TableCellEditor,
CellEditorListener,
PopupMenuListener {
    protected EnumerableEditor enumerableEditor = new EnumerableEditor();
    protected ColorEditor colorEditor = new ColorEditor();
    protected ElementEditor elementEditor = new ElementEditor();
    protected NumberEditor numberEditor = new NumberEditor();
    protected BooleanEditor booleanEditor = new BooleanEditor();
    protected DefaultCellEditor stringEditor = new DefaultCellEditor(new JTextField());
    protected DefaultEditor defaultEditor = new DefaultEditor();
    protected TableCellEditor currentEditor = null;
    protected Class currentValueClass = null;
    protected boolean isNullValid;
    protected EventListenerList listenerList = new EventListenerList();
    protected Hashtable classesToEditors = new Hashtable();
    protected Element element = null;
    private final Timer hackPopupTimer = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (PropertyCellEditor.this.currentEditor != null) {
                PropertyCellEditor.this.currentEditor.cancelCellEditing();
            }
        }
    });

    public PropertyCellEditor() {
        this.classesToEditors.put(Color.class, this.colorEditor);
        this.classesToEditors.put(edu.cmu.cs.stage3.alice.scenegraph.Color.class, this.colorEditor);
        this.classesToEditors.put(Boolean.class, this.booleanEditor);
        this.classesToEditors.put(Enumerable.class, this.enumerableEditor);
        this.classesToEditors.put(Element.class, this.elementEditor);
        this.classesToEditors.put(Number.class, this.numberEditor);
        this.classesToEditors.put(String.class, this.stringEditor);
        this.classesToEditors.put(ReferenceFrame.class, this.elementEditor);
        Enumeration enum0 = this.classesToEditors.elements();
        while (enum0.hasMoreElements()) {
            TableCellEditor editor = (TableCellEditor)enum0.nextElement();
            editor.removeCellEditorListener(this);
            editor.addCellEditorListener(this);
        }
        this.defaultEditor.addCellEditorListener(this);
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.currentEditor != null) {
            return this.currentEditor.getCellEditorValue();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject ev) {
        if (ev instanceof MouseEvent) {
            return ((MouseEvent)ev).getClickCount() >= 1;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.currentEditor != null) {
            return this.currentEditor.stopCellEditing();
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        if (this.currentEditor != null) {
            this.currentEditor.cancelCellEditing();
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Class<Object> valueClass = null;
        TableModel model = table.getModel();
        if (model instanceof TypedTableModel) {
            valueClass = ((TypedTableModel)model).getTypeAt(row, column);
            this.isNullValid = ((TypedTableModel)model).isNullValidAt(row, column);
        } else {
            this.isNullValid = true;
        }
        if (valueClass == null && value != null) {
            valueClass = value.getClass();
        }
        this.currentValueClass = valueClass;
        if (valueClass != null) {
            this.currentEditor = (TableCellEditor)this.classesToEditors.get(valueClass);
        } else {
            valueClass = Object.class;
            this.currentEditor = null;
        }
        if (this.currentEditor == null) {
            Enumeration enum0 = this.classesToEditors.keys();
            while (enum0.hasMoreElements()) {
                Class editorClass = (Class)enum0.nextElement();
                if (!editorClass.isAssignableFrom(valueClass)) continue;
                this.currentEditor = (TableCellEditor)this.classesToEditors.get(editorClass);
                break;
            }
        }
        if (this.currentEditor == null) {
            this.currentEditor = this.defaultEditor;
        }
        Component editorComponent = this.currentEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        return editorComponent;
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.hackPopupTimer.stop();
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == CellEditorListener.class) {
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(changeEvent);
            }
            i -= 2;
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == CellEditorListener.class) {
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(changeEvent);
            }
            i -= 2;
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent ev) {
        if (this.currentEditor != null) {
            this.currentEditor.cancelCellEditing();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent ev) {
        this.hackPopupTimer.setRepeats(false);
        this.hackPopupTimer.start();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
        this.hackPopupTimer.stop();
    }

    class BooleanEditor
    extends DefaultEditor {
        BooleanEditor() {
        }

        @Override
        protected Vector createPopupStructure() {
            Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
            Vector expressionStructure = this.createExpressionStructure();
            if (expressionStructure != null && expressionStructure.size() > 0) {
                structure.add(new StringObjectPair("Seperator", JSeparator.class));
                structure.add(new StringObjectPair("Expressions which evaluate to Boolean", expressionStructure));
            }
            return structure;
        }
    }

    class ColorEditor
    extends DefaultEditor {
        final JColorChooser colorChooser;
        ActionListener okListener;
        final JDialog dialog;
        Runnable customRunnable;

        ColorEditor() {
            this.colorChooser = new JColorChooser();
            this.okListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorEditor.this.currentObject = ColorEditor.this.colorChooser.getColor();
                }
            };
            this.dialog = JColorChooser.createDialog(this.editorComponent, "Pick a Color", true, this.colorChooser, this.okListener, null);
            this.customRunnable = new Runnable(){

                @Override
                public void run() {
                    PropertyCellEditor.this.hackPopupTimer.stop();
                    if (ColorEditor.this.currentObject instanceof Color) {
                        ColorEditor.this.colorChooser.setColor((Color)ColorEditor.this.currentObject);
                    }
                    ColorEditor.this.dialog.show();
                    ColorEditor.this.fireEditingStopped();
                }
            };
        }

        @Override
        protected JPopupMenu createPopupMenu() {
            JMenu menu = new JMenu("");
            return menu.getPopupMenu();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof edu.cmu.cs.stage3.alice.scenegraph.Color) {
                edu.cmu.cs.stage3.alice.scenegraph.Color c = (edu.cmu.cs.stage3.alice.scenegraph.Color)value;
                value = new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    class DefaultEditor
    extends DefaultCellEditor {
        protected Object currentObject;

        public DefaultEditor() {
            super(new JCheckBox());
            this.currentObject = null;
            JButton button = new JButton("");
            button.setBackground(Color.white);
            button.setBorderPainted(false);
            button.setMargin(new Insets(0, 0, 0, 0));
            this.editorComponent = button;
            button.addActionListener(this.createActionListener());
        }

        protected ActionListener createActionListener() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JPopupMenu popup = DefaultEditor.this.createPopupMenu();
                    if (popup != null) {
                        popup.show(DefaultEditor.this.editorComponent, 0, 0);
                        PopupMenuUtilities.ensurePopupIsOnScreen(popup);
                        popup.addPopupMenuListener(PropertyCellEditor.this);
                    }
                }
            };
        }

        protected JPopupMenu createPopupMenu() {
            Vector structure = this.createPopupStructure();
            if (structure != null) {
                return PopupMenuUtilities.makePopupMenu(structure);
            }
            return null;
        }

        protected Vector createPopupStructure() {
            Vector structure = this.createExpressionStructure();
            if (structure != null && PropertyCellEditor.this.isNullValid && structure.size() > 0) {
                structure.insertElementAt(new StringObjectPair("Separator", JSeparator.class), 0);
            }
            return structure;
        }

        protected Vector createExpressionStructure() {
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentObject;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentObject = value;
            return this.editorComponent;
        }

        class ObjectRunnable
        implements Runnable {
            Object object;

            public ObjectRunnable(Object object) {
                this.object = object;
            }

            @Override
            public void run() {
                DefaultEditor.this.currentObject = this.object;
                DefaultEditor.this.fireEditingStopped();
            }
        }
    }

    class ElementEditor
    extends DefaultEditor {
        ElementEditor() {
        }

        @Override
        protected Vector createPopupStructure() {
            return null;
        }
    }

    class EnumerableEditor
    extends DefaultEditor {
        EnumerableEditor() {
        }

        @Override
        protected Vector createPopupStructure() {
            Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
            Enumerable[] items = Enumerable.getItems(PropertyCellEditor.this.currentValueClass);
            int i = 0;
            while (i < items.length) {
                ++i;
            }
            Vector expressionStructure = this.createExpressionStructure();
            if (expressionStructure != null && expressionStructure.size() > 0) {
                String className = PropertyCellEditor.this.currentValueClass.getName();
                structure.add(new StringObjectPair("Seperator", JSeparator.class));
                structure.add(new StringObjectPair("Expressions which evaluate to " + className, expressionStructure));
            }
            if (PropertyCellEditor.this.isNullValid && structure.size() > 0) {
                structure.insertElementAt(new StringObjectPair("Separator", JSeparator.class), 0);
            }
            return structure;
        }
    }

    class NumberEditor
    extends DefaultCellEditor {
        protected Object currentNumber;
        protected JPanel panel;
        protected JTextField textField;
        protected JButton button;

        public NumberEditor() {
            super(new JCheckBox());
            this.currentNumber = null;
            this.panel = new JPanel();
            this.textField = new JTextField();
            this.button = new JButton("Element...");
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.textField, "Center");
            this.panel.add((Component)this.button, "East");
            this.editorComponent = this.panel;
            this.textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String input = NumberEditor.this.textField.getText();
                    try {
                        Double value = Double.valueOf(input);
                        NumberEditor.this.currentNumber = value;
                    }
                    catch (NumberFormatException ex) {
                        if (NumberEditor.this.currentNumber != null) {
                            NumberEditor.this.textField.setText(NumberEditor.this.currentNumber.toString());
                        }
                        NumberEditor.this.textField.setText("");
                    }
                    NumberEditor.this.fireEditingStopped();
                }
            });
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AliceMenuWithDelayedPopup menu;
                    Vector structure = null;
                    if (structure != null && (menu = PopupMenuUtilities.makeMenu("", structure)) != null) {
                        JPopupMenu popup = ((JMenu)menu).getPopupMenu();
                        popup.show(NumberEditor.this.button, 0, 0);
                        PopupMenuUtilities.ensurePopupIsOnScreen(popup);
                        popup.addPopupMenuListener(PropertyCellEditor.this);
                    }
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentNumber;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentNumber = value;
            if (this.currentNumber instanceof Number) {
                this.textField.setText(this.currentNumber.toString());
            } else {
                this.textField.setText("");
            }
            Element[] elements = PropertyCellEditor.this.element.getRoot().search(new ExpressionIsAssignableToCriterion(Number.class));
            if (elements.length > 0) {
                this.button.setEnabled(true);
            } else {
                this.button.setEnabled(false);
            }
            return this.editorComponent;
        }

        class NumberExpressionRunnable
        implements Runnable {
            Expression expression;

            public NumberExpressionRunnable(Expression expression) {
                this.expression = expression;
            }

            @Override
            public void run() {
                if (Number.class.isAssignableFrom(this.expression.getValueClass())) {
                    NumberEditor.this.currentNumber = this.expression;
                }
                NumberEditor.this.fireEditingStopped();
            }
        }
    }
}

