/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.util.Enumerable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Array;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class PropertyCellRenderer
extends DefaultTableCellRenderer {
    protected ColorRenderer colorRenderer = new ColorRenderer();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        String toolTipText = null;
        if (value != null) {
            toolTipText = value instanceof Element ? ((Element)value).getKey() : (value instanceof String ? "\"" + this.getText() + "\"" : this.getText());
            String classString = value.getClass().getName();
            if (classString.startsWith("edu.cmu.cs.stage3.")) {
                classString = classString.substring("edu.cmu.cs.stage3.".length());
            }
            toolTipText = String.valueOf(toolTipText) + " (" + classString + ")";
        }
        this.setToolTipText(toolTipText);
        if (value instanceof Element) {
            this.setText(AuthoringToolResources.getReprForValue(value));
        } else {
            if (value instanceof Color || value instanceof edu.cmu.cs.stage3.alice.scenegraph.Color) {
                this.colorRenderer.setToolTipText(toolTipText);
                return this.colorRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            if (value != null && value.getClass().isArray()) {
                String text = "";
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(3);
                text = "{ ";
                int m = Array.getLength(value);
                int i = 0;
                while (i < m) {
                    Object o = Array.get(value, i);
                    if (o.getClass().isArray()) {
                        text = String.valueOf(text) + "{ ";
                        int n = Array.getLength(o);
                        int j = 0;
                        while (j < n) {
                            Object p = Array.get(o, j);
                            text = p instanceof Number ? String.valueOf(text) + nf.format(p) : String.valueOf(text) + p;
                            text = j < n - 1 ? String.valueOf(text) + ", " : String.valueOf(text) + " ";
                            ++j;
                        }
                        text = String.valueOf(text) + "}";
                    } else {
                        text = o instanceof Element ? String.valueOf(text) + AuthoringToolResources.getReprForValue(o) : (o instanceof Number ? String.valueOf(text) + nf.format(o) : String.valueOf(text) + o);
                    }
                    text = i < m - 1 ? String.valueOf(text) + ", " : String.valueOf(text) + " ";
                    if (text.length() > 64) {
                        text = String.valueOf(text) + "...";
                        break;
                    }
                    ++i;
                }
                text = String.valueOf(text) + "}";
                this.setText(text);
            } else if (value instanceof Enumerable) {
                this.setText(((Enumerable)value).getRepr());
            } else if (value instanceof Enumeration) {
                this.setText(Messages.getString("_enumeration_"));
            }
        }
        return this;
    }

    class ColorRenderer
    extends DefaultTableCellRenderer {
        Hashtable colorsToIcons = new Hashtable();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            if (color instanceof edu.cmu.cs.stage3.alice.scenegraph.Color) {
                edu.cmu.cs.stage3.alice.scenegraph.Color c = (edu.cmu.cs.stage3.alice.scenegraph.Color)color;
                color = new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
            }
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            Icon icon = (Icon)this.colorsToIcons.get(color);
            if (icon == null) {
                int height = table.getRowHeight() - 4;
                int width = height * 2;
                BufferedImage colorImage = new BufferedImage(width, height, 1);
                Graphics2D g = colorImage.createGraphics();
                g.setColor((Color)color);
                g.fill3DRect(0, 0, width, height, true);
                icon = new ImageIcon(colorImage);
                this.colorsToIcons.put(color, icon);
            }
            this.setIcon(icon);
            this.setFont(table.getFont());
            this.setText(this.getTextFromColor((Color)color));
            return this;
        }

        public String getTextFromColor(Color color) {
            String text = "";
            if (color.equals(Color.black)) {
                text = Messages.getString("black");
            } else if (color.equals(Color.blue)) {
                text = Messages.getString("blue");
            } else if (color.equals(Color.cyan)) {
                text = Messages.getString("cyan");
            } else if (color.equals(Color.darkGray)) {
                text = Messages.getString("darkGray");
            } else if (color.equals(Color.gray)) {
                text = Messages.getString("gray");
            } else if (color.equals(Color.green)) {
                text = Messages.getString("green");
            } else if (color.equals(Color.lightGray)) {
                text = Messages.getString("lightGray");
            } else if (color.equals(Color.magenta)) {
                text = Messages.getString("magenta");
            } else if (color.equals(Color.orange)) {
                text = Messages.getString("orange");
            } else if (color.equals(Color.pink)) {
                text = Messages.getString("pink");
            } else if (color.equals(Color.red)) {
                text = Messages.getString("red");
            } else if (color.equals(Color.white)) {
                text = Messages.getString("white");
            } else if (color.equals(Color.yellow)) {
                text = Messages.getString("yellow");
            } else {
                float[] rgba = new float[4];
                color.getComponents(rgba);
                text = String.valueOf(Messages.getString("_red___")) + rgba[0] + Messages.getString("__green___") + rgba[1] + Messages.getString("__blue___") + rgba[2] + Messages.getString("__alpha___") + rgba[3] + ">";
            }
            return text;
        }
    }
}

