/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.MainUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultMoveMode;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Scheduler;
import edu.cmu.cs.stage3.alice.core.camera.OrthographicCamera;
import edu.cmu.cs.stage3.math.MathUtilities;
import java.awt.event.MouseEvent;

public class RaiseLowerMode
extends DefaultMoveMode {
    public RaiseLowerMode(MainUndoRedoStack undoRedoStack, Scheduler scheduler) {
        super(undoRedoStack, scheduler);
    }

    @Override
    public void mouseDragged(MouseEvent ev, int dx, int dy) {
        if (this.pickedTransformable != null) {
            double deltaFactor;
            if (this.camera instanceof OrthographicCamera) {
                OrthographicCamera orthoCamera = (OrthographicCamera)this.camera;
                double nearClipHeightInScreen = this.renderTarget.getAWTComponent().getHeight();
                double nearClipHeightInWorld = orthoCamera.getSceneGraphOrthographicCamera().getPlane()[3] - orthoCamera.getSceneGraphOrthographicCamera().getPlane()[1];
                deltaFactor = nearClipHeightInWorld / nearClipHeightInScreen;
            } else {
                double projectionMatrix11 = this.renderTarget.getProjectionMatrix(this.camera.getSceneGraphCamera()).getElement(1, 1);
                double nearClipDist = this.camera.nearClippingPlaneDistance.doubleValue();
                double nearClipHeightInWorld = 2.0 * (nearClipDist / projectionMatrix11);
                double nearClipHeightInScreen = this.renderTarget.getAWTComponent().getHeight();
                double pixelHeight = nearClipHeightInWorld / nearClipHeightInScreen;
                double objectDist = this.pickedTransformable.getPosition(this.camera).getLength();
                deltaFactor = objectDist * pixelHeight / nearClipDist;
            }
            this.helper.setTransformationRightNow(MathUtilities.createIdentityMatrix4d(), this.world);
            this.helper.setPositionRightNow(this.zeroVec, this.pickedTransformable);
            this.tempVec.x = 0.0;
            this.tempVec.y = (double)(-dy) * deltaFactor;
            this.tempVec.z = 0.0;
            this.pickedTransformable.moveRightNow(this.tempVec, (ReferenceFrame)this.helper);
        }
    }
}

