/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.JWindow;

public class RectangleAnimator
extends JWindow
implements Runnable {
    protected AuthoringTool authoringTool;
    protected Rectangle sourceBounds;
    protected Rectangle targetBounds;
    protected long duration = 300L;
    protected long startTime;

    public RectangleAnimator(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    public Color getColor() {
        return this.getBackground();
    }

    public void setColor(Color color) {
        this.setBackground(color);
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Rectangle getSourceBounds() {
        return this.sourceBounds;
    }

    public void setSourceBounds(Rectangle r) {
        this.sourceBounds = r;
    }

    public Rectangle gettargetBounds() {
        return this.targetBounds;
    }

    public void setTargetBounds(Rectangle r) {
        this.targetBounds = r;
    }

    public void animate(Rectangle sourceBounds, Rectangle targetBounds) {
        this.setSourceBounds(sourceBounds);
        this.setTargetBounds(targetBounds);
        this.setBounds(sourceBounds);
        this.setVisible(true);
        this.startTime = System.currentTimeMillis();
        this.authoringTool.getScheduler().addEachFrameRunnable(this);
    }

    public void animate(Rectangle sourceBounds, Rectangle targetBounds, Color color) {
        this.setColor(color);
        this.animate(sourceBounds, targetBounds);
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        long dt = time - this.startTime;
        if (dt <= this.duration) {
            double portion = (double)dt / (double)this.duration;
            int x = this.sourceBounds.x + (int)(portion * (double)(this.targetBounds.x - this.sourceBounds.x));
            int y = this.sourceBounds.y + (int)(portion * (double)(this.targetBounds.y - this.sourceBounds.y));
            int w = this.sourceBounds.width + (int)(portion * (double)(this.targetBounds.width - this.sourceBounds.width));
            int h = this.sourceBounds.height + (int)(portion * (double)(this.targetBounds.height - this.sourceBounds.height));
            this.setBounds(x, y, w, h);
            this.repaint();
        } else {
            this.setVisible(false);
            this.authoringTool.getScheduler().removeEachFrameRunnable(this);
        }
    }
}

