/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPopupUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.ScreenWrappingMouseListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.RenderTargetPickManipulatorEvent;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.RenderTargetPickManipulatorListener;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import edu.cmu.cs.stage3.awt.AWTUtilities;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public abstract class RenderTargetPickManipulator
extends ScreenWrappingMouseListener {
    protected edu.cmu.cs.stage3.alice.core.Transformable ePickedTransformable = null;
    protected edu.cmu.cs.stage3.alice.core.Transformable lastEPickedTransformable = null;
    protected Transformable sgPickedTransformable = null;
    protected OnscreenRenderTarget renderTarget = null;
    protected HashSet objectsOfInterest = new HashSet();
    protected HashSet listeners = new HashSet();
    protected Cursor invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(""), new Point(0, 0), "invisible cursor");
    protected Cursor savedCursor = Cursor.getDefaultCursor();
    protected Point originalMousePoint;
    protected boolean hideCursorOnDrag = true;
    protected boolean popupEnabled = false;
    protected boolean enabled = true;
    protected boolean pickAllForOneObjectOfInterest = true;
    protected boolean ascendTreeEnabled = true;
    protected PickInfo pickInfo;
    protected final MouseListener popupMouseListener = new CustomMouseAdapter(){
        Runnable emptyRunnable = new Runnable(){

            @Override
            public void run() {
            }
        };

        @Override
        protected void popupResponse(MouseEvent e) {
            if (RenderTargetPickManipulator.this.lastEPickedTransformable != null) {
                JPopupMenu popup = this.createPopup(RenderTargetPickManipulator.this.lastEPickedTransformable);
                popup.show(e.getComponent(), e.getX(), e.getY());
                PopupMenuUtilities.ensurePopupIsOnScreen(popup);
            }
        }

        private JPopupMenu createPopup(Element element) {
            Vector popupStructure = ElementPopupUtilities.getDefaultStructure(element);
            return ElementPopupUtilities.makeElementPopupMenu(element, popupStructure);
        }
    };

    public RenderTargetPickManipulator(OnscreenRenderTarget renderTarget) {
        this.setRenderTarget(renderTarget);
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setPickAllForOneObjectOfInterestEnabled(boolean b) {
        this.pickAllForOneObjectOfInterest = b;
    }

    public boolean isPickAllForOneObjectOfInterestEnabled() {
        return this.pickAllForOneObjectOfInterest;
    }

    public void setRenderTarget(OnscreenRenderTarget renderTarget) {
        if (this.renderTarget != null) {
            this.renderTarget.getAWTComponent().removeMouseListener(this);
            if (this.popupEnabled) {
                this.renderTarget.getAWTComponent().removeMouseListener(this.popupMouseListener);
            }
        }
        this.renderTarget = renderTarget;
        if (renderTarget != null) {
            renderTarget.getAWTComponent().addMouseListener(this);
            if (this.popupEnabled) {
                this.renderTarget.getAWTComponent().addMouseListener(this.popupMouseListener);
            }
        }
    }

    public RenderTarget getRenderTarget() {
        return this.renderTarget;
    }

    public edu.cmu.cs.stage3.alice.core.Transformable getCorePickedTransformable() {
        return this.ePickedTransformable;
    }

    public Transformable getSceneGraphPickedTransformable() {
        return this.sgPickedTransformable;
    }

    public void addRenderTargetPickManipulatorListener(RenderTargetPickManipulatorListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeRenderTargetPickManipulatorListener(RenderTargetPickManipulatorListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public boolean addObjectOfInterest(edu.cmu.cs.stage3.alice.core.Transformable trans) {
        return this.objectsOfInterest.add(trans);
    }

    public boolean removeObjectOfInterest(edu.cmu.cs.stage3.alice.core.Transformable trans) {
        return this.objectsOfInterest.remove(trans);
    }

    public void clearObjectsOfInterestList() {
        this.objectsOfInterest.clear();
    }

    public boolean getHideCursorOnDrag() {
        return this.hideCursorOnDrag;
    }

    public void setHideCursorOnDrag(boolean b) {
        this.hideCursorOnDrag = b;
    }

    public void setAscendTreeEnabled(boolean b) {
        this.ascendTreeEnabled = b;
    }

    public boolean isAscendTreeEnabled() {
        return this.ascendTreeEnabled;
    }

    public boolean isPopupEnabled() {
        return this.popupEnabled;
    }

    public synchronized void setPopupEnabled(boolean b) {
        if (this.renderTarget != null) {
            if (b && !this.popupEnabled) {
                this.renderTarget.getAWTComponent().addMouseListener(this.popupMouseListener);
            } else if (!b && this.popupEnabled) {
                this.renderTarget.getAWTComponent().removeMouseListener(this.popupMouseListener);
            }
        }
        this.popupEnabled = b;
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (this.enabled) {
            super.mousePressed(ev);
            this.firePrePick();
            if (this.objectsOfInterest.size() == 1 && this.pickAllForOneObjectOfInterest) {
                this.ePickedTransformable = (edu.cmu.cs.stage3.alice.core.Transformable)this.objectsOfInterest.iterator().next();
                this.sgPickedTransformable = this.ePickedTransformable.getSceneGraphTransformable();
            } else {
                if (AuthoringTool.getHack() != null && AuthoringTool.getHack().getUndoRedoStack() != null) {
                    AuthoringTool.getHack().getUndoRedoStack().setIsListening(false);
                }
                this.pickInfo = this.renderTarget.pick(ev.getX(), ev.getY(), false, true);
                if (this.pickInfo != null) {
                    Visual[] visuals = this.pickInfo.getVisuals();
                    if (visuals != null && visuals.length >= 1) {
                        this.ePickedTransformable = (edu.cmu.cs.stage3.alice.core.Transformable)visuals[0].getBonus();
                        if (this.ePickedTransformable == null) {
                            this.sgPickedTransformable = (Transformable)visuals[0].getParent();
                            this.ePickedTransformable = (edu.cmu.cs.stage3.alice.core.Transformable)this.sgPickedTransformable.getBonus();
                        } else {
                            this.sgPickedTransformable = this.ePickedTransformable.getSceneGraphTransformable();
                        }
                        if (this.ascendTreeEnabled) {
                            while (this.ePickedTransformable != null && this.ePickedTransformable.getParent() instanceof edu.cmu.cs.stage3.alice.core.Transformable && !this.ePickedTransformable.doEventsStopAscending() && !this.objectsOfInterest.contains(this.ePickedTransformable)) {
                                this.sgPickedTransformable = ((edu.cmu.cs.stage3.alice.core.Transformable)this.ePickedTransformable.getParent()).getSceneGraphTransformable();
                                this.ePickedTransformable = (edu.cmu.cs.stage3.alice.core.Transformable)this.sgPickedTransformable.getBonus();
                            }
                        }
                        if (!this.objectsOfInterest.isEmpty() && !this.objectsOfInterest.contains(this.ePickedTransformable)) {
                            this.abortAction();
                        }
                    } else {
                        this.sgPickedTransformable = null;
                        this.ePickedTransformable = null;
                    }
                } else {
                    this.sgPickedTransformable = null;
                    this.ePickedTransformable = null;
                }
            }
            this.firePostPick(this.pickInfo);
            this.originalMousePoint = ev.getPoint();
            if (!this.isActionAborted() && this.hideCursorOnDrag && this.doWrap && !ev.getComponent().getCursor().equals(this.invisibleCursor)) {
                this.savedCursor = ev.getComponent().getCursor();
                ev.getComponent().setCursor(this.invisibleCursor);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (!this.isActionAborted() && this.hideCursorOnDrag && this.doWrap) {
            ev.getComponent().setCursor(this.savedCursor);
            Point tempPoint = ev.getPoint();
            SwingUtilities.convertPointToScreen(tempPoint, ev.getComponent());
            SwingUtilities.convertPointToScreen(this.originalMousePoint, ev.getComponent());
            AWTUtilities.setCursorLocation(tempPoint.x, this.originalMousePoint.y);
        }
        this.lastEPickedTransformable = this.ePickedTransformable;
        this.ePickedTransformable = null;
        this.sgPickedTransformable = null;
        this.pickInfo = null;
        if (AuthoringTool.getHack() != null && AuthoringTool.getHack().getUndoRedoStack() != null) {
            AuthoringTool.getHack().getUndoRedoStack().setIsListening(true);
        }
        super.mouseReleased(ev);
    }

    @Override
    public void abortAction() {
        this.component.setCursor(this.savedCursor);
        super.abortAction();
    }

    protected void firePrePick() {
        RenderTargetPickManipulatorEvent ev = new RenderTargetPickManipulatorEvent(this.renderTarget, null);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((RenderTargetPickManipulatorListener)iter.next()).prePick(ev);
        }
    }

    protected void firePostPick(PickInfo pickInfo) {
        RenderTargetPickManipulatorEvent ev = new RenderTargetPickManipulatorEvent(this.renderTarget, pickInfo);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((RenderTargetPickManipulatorListener)iter.next()).postPick(ev);
        }
    }
}

