/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.scripting.Code;
import edu.cmu.cs.stage3.alice.scripting.CompileType;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.PlainDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;

public class ScriptEditorPane
extends JEditorPane {
    protected Sandbox sandbox;
    protected Action[] actions;
    protected JPopupMenu popup;
    protected String findString = "";
    protected String replaceWithString = "";
    protected boolean matchCase = false;
    protected boolean findFromStart = true;
    public final Action performAllAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            block3: {
                if (ScriptEditorPane.this.sandbox != null) {
                    String script = ScriptEditorPane.this.getText();
                    try {
                        Code code = ScriptEditorPane.this.sandbox.compile(script, "<ScriptEditorPane>", CompileType.EXEC_MULTIPLE);
                        ScriptEditorPane.this.sandbox.exec(code);
                    }
                    catch (PyException e) {
                        if (Py.matchException((PyException)e, (PyObject)Py.SystemExit)) break block3;
                        Py.printException((Throwable)e, null, (PyObject)AuthoringTool.getPyStdErr());
                    }
                }
            }
        }
    };
    public final Action performSelectedAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ScriptEditorPane.this.sandbox != null) {
                try {
                    int selectionStart = ScriptEditorPane.this.getLineStartOffset(ScriptEditorPane.this.getLineOfOffset(ScriptEditorPane.this.getSelectionStart()));
                    int selectionEnd = ScriptEditorPane.this.getLineEndOffset(ScriptEditorPane.this.getLineOfOffset(ScriptEditorPane.this.getSelectionEnd()));
                    String script = ScriptEditorPane.this.getText(selectionStart, selectionEnd - selectionStart);
                    try {
                        Code code = ScriptEditorPane.this.sandbox.compile(script, "<ScriptEditorPane>", CompileType.EXEC_MULTIPLE);
                        ScriptEditorPane.this.sandbox.exec(code);
                    }
                    catch (PyException e) {
                        if (!Py.matchException((PyException)e, (PyObject)Py.SystemExit)) {
                            Py.printException((Throwable)e, null, (PyObject)AuthoringTool.getPyStdErr());
                        }
                    }
                }
                catch (BadLocationException ble) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_getting_selected_code_"), ble);
                }
            }
        }
    };
    protected final MouseListener editorPaneMouseListener = new CustomMouseAdapter(){

        @Override
        protected void popupResponse(MouseEvent e) {
            ScriptEditorPane.this.popupInit();
            ScriptEditorPane.this.popup.show(e.getComponent(), e.getX(), e.getY());
            PopupMenuUtilities.ensurePopupIsOnScreen(ScriptEditorPane.this.popup);
        }
    };
    public final UndoAction undoAction = new UndoAction();
    public final RedoAction redoAction = new RedoAction();
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undoManager = new UndoManager();

    public ScriptEditorPane() {
        this.actionInit();
        this.popupInit();
        this.setDefaultKeyBindingsEnabled(true);
        this.setFont(new Font("Monospaced", 0, 12));
        this.getDocument().addUndoableEditListener(this.undoHandler);
        this.addMouseListener(this.editorPaneMouseListener);
        this.setSize(new Dimension(10000, 100));
    }

    private void actionInit() {
        this.performAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 2));
        this.performAllAction.putValue("ActionCommandKey", "performAll");
        this.performAllAction.putValue("MnemonicKey", new Integer(65));
        this.performAllAction.putValue("Name", Messages.getString("Perform_All__Ctrl_F4_"));
        this.performAllAction.putValue("ShortDescription", Messages.getString("Performs_the_entire_script_"));
        this.performSelectedAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 0));
        this.performSelectedAction.putValue("ActionCommandKey", "performSelected");
        this.performSelectedAction.putValue("MnemonicKey", new Integer(83));
        this.performSelectedAction.putValue("Name", Messages.getString("Perform_Selected__F4_"));
        this.performSelectedAction.putValue("ShortDescription", Messages.getString("Performs_the_selected_lines_of_the_script__or_the_line_the_cursor_is_on_if_there_is_no_selection_"));
        this.undoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
        this.undoAction.putValue("ActionCommandKey", "undoEdit");
        this.undoAction.putValue("MnemonicKey", new Integer(85));
        this.undoAction.putValue("Name", Messages.getString("Undo__Ctrl_Z_"));
        this.undoAction.putValue("ShortDescription", Messages.getString("Undo_last_edit"));
        this.redoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 2));
        this.redoAction.putValue("ActionCommandKey", "redoEdit");
        this.redoAction.putValue("MnemonicKey", new Integer(82));
        this.redoAction.putValue("Name", Messages.getString("Redo__Ctrl_Y_"));
        this.redoAction.putValue("ShortDescription", Messages.getString("Redo_last_undo"));
        this.actions = new Action[]{this.performAllAction, this.performSelectedAction, this.undoAction, this.redoAction};
    }

    private void popupInit() {
        this.popup = new JPopupMenu("");
        if (this.performAllAction.isEnabled()) {
            this.popup.add(this.performAllAction);
        }
        if (this.performSelectedAction.isEnabled()) {
            this.popup.add(this.performSelectedAction);
        }
        if (this.performAllAction.isEnabled() || this.performSelectedAction.isEnabled()) {
            this.popup.addSeparator();
        }
        this.popup.add(this.undoAction);
        this.popup.add(this.redoAction);
    }

    public boolean findNext(String stringToFind) {
        int startFrom = this.getSelectionStart() != this.getSelectionEnd() ? this.getSelectionEnd() : this.getCaretPosition();
        String script = this.getText();
        int startSelection = this.matchCase ? script.indexOf(stringToFind, startFrom) : script.toLowerCase().indexOf(stringToFind.toLowerCase(), startFrom);
        int endSelection = startSelection + stringToFind.length();
        if (startSelection >= 0 && endSelection <= script.length()) {
            this.select(startSelection, endSelection);
            return true;
        }
        return false;
    }

    public void replaceCurrent(String stringToReplaceWith) {
        this.replaceSelection(stringToReplaceWith);
    }

    public void replaceAllRemaining(String stringToFind, String stringToReplaceWith) {
        int currentPosition = this.getCaretPosition();
        if (this.findNext(this.findString)) {
            this.replaceCurrent(stringToReplaceWith);
            while (this.findNext(stringToFind)) {
                this.replaceCurrent(stringToReplaceWith);
            }
        } else {
            DialogManager.showMessageDialog(String.valueOf(Messages.getString("String__")) + this.findString + " " + Messages.getString("not_found_"), Messages.getString("String_not_found"), 1);
        }
        this.setCaretPosition(currentPosition);
    }

    @Override
    public void setDocument(Document doc) {
        super.setDocument(doc);
        this.getDocument().addUndoableEditListener(this.undoHandler);
    }

    public Element getSandbox() {
        return this.sandbox;
    }

    public void setSandbox(Sandbox sandbox) {
        this.sandbox = sandbox;
    }

    public void setDefaultKeyBindingsEnabled(boolean b) {
        this.setDefaultKeyBindingsEnabled(b, this.actions);
    }

    public void setDefaultKeyBindingsEnabled(boolean b, Action[] whichActions) {
        Keymap keymap = this.getKeymap();
        if (b) {
            int i = 0;
            while (i < whichActions.length) {
                this.getInputMap().put((KeyStroke)whichActions[i].getValue("AcceleratorKey"), whichActions[i].getValue("ActionCommandKey"));
                this.getActionMap().put(whichActions[i].getValue("ActionCommandKey"), whichActions[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < whichActions.length) {
                this.getInputMap().remove((KeyStroke)whichActions[i].getValue("AcceleratorKey"));
                this.getActionMap().remove(whichActions[i].getValue("ActionCommandKey"));
                ++i;
            }
        }
    }

    public int getCurrentLineNumber() {
        try {
            return this.getLineOfOffset(this.getCaretPosition());
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        Document doc = this.getDocument();
        if (doc instanceof PlainDocument) {
            if (offset < 0) {
                throw new BadLocationException(Messages.getString("Can_t_translate_offset_to_line"), -1);
            }
            if (offset > doc.getLength()) {
                throw new BadLocationException(Messages.getString("Can_t_translate_offset_to_line"), doc.getLength() + 1);
            }
            javax.swing.text.Element map = this.getDocument().getDefaultRootElement();
            return map.getElementIndex(offset);
        }
        throw new UnsupportedOperationException(Messages.getString("Cannot_find_line_number__only_PlainDocuments_supported_at_this_time_"));
    }

    public int getLineStartOffset(int line) throws BadLocationException {
        Document doc = this.getDocument();
        if (doc instanceof PlainDocument) {
            javax.swing.text.Element map = doc.getDefaultRootElement();
            if (line < 0) {
                throw new BadLocationException(Messages.getString("Negative_line"), -1);
            }
            if (line >= map.getElementCount()) {
                throw new BadLocationException(Messages.getString("No_such_line"), this.getDocument().getLength() + 1);
            }
            javax.swing.text.Element lineElem = map.getElement(line);
            return lineElem.getStartOffset();
        }
        throw new UnsupportedOperationException(Messages.getString("Cannot_find_line_start_offset__only_PlainDocuments_supported_at_this_time_"));
    }

    public int getLineEndOffset(int line) throws BadLocationException {
        Document doc = this.getDocument();
        if (doc instanceof PlainDocument) {
            javax.swing.text.Element map = doc.getDefaultRootElement();
            if (line < 0) {
                throw new BadLocationException(Messages.getString("Negative_line"), -1);
            }
            if (line >= map.getElementCount()) {
                throw new BadLocationException(Messages.getString("No_such_line"), this.getDocument().getLength() + 1);
            }
            javax.swing.text.Element lineElem = map.getElement(line);
            return lineElem.getEndOffset();
        }
        throw new UnsupportedOperationException(Messages.getString("Cannot_find_line_end_offset__only_PlainDocuments_supported_at_this_time_"));
    }

    public void resetUndoManager() {
        this.undoManager.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(Messages.getString("Redo"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            try {
                ScriptEditorPane.this.undoManager.redo();
            }
            catch (CannotRedoException e) {
                AuthoringTool.showErrorDialog(Messages.getString("Error__unable_to_redo_"), e);
            }
            this.update();
            ScriptEditorPane.this.undoAction.update();
        }

        protected void update() {
            if (ScriptEditorPane.this.undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", ScriptEditorPane.this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", Messages.getString("Redo"));
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(Messages.getString("Undo"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            try {
                ScriptEditorPane.this.undoManager.undo();
            }
            catch (CannotUndoException e) {
                AuthoringTool.showErrorDialog(Messages.getString("Error__unable_to_undo_"), e);
            }
            this.update();
            ScriptEditorPane.this.redoAction.update();
        }

        protected void update() {
            if (ScriptEditorPane.this.undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", ScriptEditorPane.this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", Messages.getString("Undo"));
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent ev) {
            ScriptEditorPane.this.undoManager.addEdit(ev.getEdit());
            ScriptEditorPane.this.undoAction.update();
            ScriptEditorPane.this.redoAction.update();
        }
    }
}

