/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.caitlin.stencilhelp.application.StateCapsule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class StencilStateCapsule
implements StateCapsule {
    protected ArrayList existantElements = new ArrayList();
    protected ArrayList nonExistantElements = new ArrayList();
    protected HashMap propertyValues = new HashMap();
    protected HashMap elementPositions = new HashMap();

    public void addExistantElement(String elementKey) {
        this.existantElements.add(elementKey);
    }

    public void removeExistantElement(String elementKey) {
        this.existantElements.remove(elementKey);
    }

    public String[] getExistantElements() {
        return this.existantElements.toArray(new String[0]);
    }

    public void addNonExistantElement(String elementKey) {
        this.nonExistantElements.add(elementKey);
    }

    public void removeNonExistantElement(String elementKey) {
        this.nonExistantElements.remove(elementKey);
    }

    public String[] getNonExistantElements() {
        return this.nonExistantElements.toArray(new String[0]);
    }

    public void putPropertyValue(String propertyKey, String valueRepr) {
        this.propertyValues.put(propertyKey, valueRepr);
    }

    public void removePropertyValue(String propertyKey) {
        this.propertyValues.remove(propertyKey);
    }

    public void putElementPosition(String elementKey, int position) {
        this.elementPositions.put(elementKey, new Integer(position));
    }

    public void removeElementPosition(String elementKey) {
        this.elementPositions.remove(elementKey);
    }

    public int getElementPosition(String elementKey) {
        Integer value = (Integer)this.elementPositions.get(elementKey);
        if (value != null) {
            return value;
        }
        return -1;
    }

    public String getPropertyValue(String propertyKey) {
        return (String)this.propertyValues.get(propertyKey);
    }

    public Set getPropertyValueKeySet() {
        return this.propertyValues.keySet();
    }

    public Set getElementPositionKeySet() {
        return this.elementPositions.keySet();
    }

    @Override
    public void parse(String storableRepr) {
        String valueRepr;
        int colonIndex;
        StringTokenizer st = new StringTokenizer(storableRepr, "|", false);
        String token = st.nextToken();
        if (!"existantElements".equals(token)) {
            throw new IllegalArgumentException("expected \"existantElements\"; got " + token);
        }
        StringTokenizer st2 = new StringTokenizer(st.nextToken(), "?", false);
        while (st2.hasMoreTokens()) {
            this.addExistantElement(st2.nextToken());
        }
        token = st.nextToken();
        if (!"nonExistantElements".equals(token)) {
            throw new IllegalArgumentException("expected \"nonExistantElements\"; got " + token);
        }
        st2 = new StringTokenizer(st.nextToken(), "?", false);
        while (st2.hasMoreTokens()) {
            this.addNonExistantElement(st2.nextToken());
        }
        token = st.nextToken();
        if (!"propertyValues".equals(token)) {
            throw new IllegalArgumentException("expected \"propertyValues\"; got " + token);
        }
        st2 = new StringTokenizer(st.nextToken(), "?", false);
        while (st2.hasMoreTokens()) {
            token = st2.nextToken();
            colonIndex = token.indexOf(":");
            String propertyKey = token.substring(0, colonIndex);
            valueRepr = token.substring(colonIndex + 1);
            this.putPropertyValue(propertyKey, valueRepr);
        }
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            if (!"elementPositions".equals(token)) {
                throw new IllegalArgumentException("expected \"elementPositions\"; got " + token);
            }
            st2 = new StringTokenizer(st.nextToken(), "?", false);
            while (st2.hasMoreTokens()) {
                token = st2.nextToken();
                colonIndex = token.indexOf(":");
                String elementKey = token.substring(0, colonIndex);
                valueRepr = token.substring(colonIndex + 1);
                this.putElementPosition(elementKey, Integer.parseInt(valueRepr));
            }
        }
    }

    @Override
    public String getStorableRepr() {
        Object valueRepr;
        String storableRepr = "";
        storableRepr = String.valueOf(storableRepr) + "existantElements|?";
        Iterator<Object> iter = this.existantElements.iterator();
        while (iter.hasNext()) {
            storableRepr = String.valueOf(storableRepr) + (String)iter.next() + "?";
        }
        storableRepr = String.valueOf(storableRepr) + "|";
        storableRepr = String.valueOf(storableRepr) + "nonExistantElements|?";
        iter = this.nonExistantElements.iterator();
        while (iter.hasNext()) {
            storableRepr = String.valueOf(storableRepr) + (String)iter.next() + "?";
        }
        storableRepr = String.valueOf(storableRepr) + "|";
        storableRepr = String.valueOf(storableRepr) + "propertyValues|?";
        for (String propertyKey : this.propertyValues.keySet()) {
            valueRepr = (String)this.propertyValues.get(propertyKey);
            storableRepr = String.valueOf(storableRepr) + propertyKey + ":" + (String)valueRepr + "?";
        }
        storableRepr = String.valueOf(storableRepr) + "|";
        storableRepr = String.valueOf(storableRepr) + "elementPositions|?";
        for (String elementKey : this.elementPositions.keySet()) {
            valueRepr = (Integer)this.elementPositions.get(elementKey);
            storableRepr = String.valueOf(storableRepr) + elementKey + ":" + valueRepr + "?";
        }
        storableRepr = String.valueOf(storableRepr) + "|";
        return storableRepr;
    }
}

