/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyledStreamTextPane;
import edu.cmu.cs.stage3.lang.Messages;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import org.mozilla.universalchardet.UniversalDetector;

public class StyleStream
extends PrintStream {
    protected Style style;
    protected StyledStreamTextPane styledStreamTextPane;

    public StyleStream(StyledStreamTextPane styledStreamTextPane, Style style) throws UnsupportedEncodingException {
        super((OutputStream)System.out, true, "UTF-8");
        this.styledStreamTextPane = styledStreamTextPane;
        this.style = style;
    }

    @Override
    public void write(int b) {
        try {
            this.styledStreamTextPane.document.insertString(this.styledStreamTextPane.endPosition.getOffset() - 1, String.valueOf(b), this.style);
        }
        catch (BadLocationException e) {
            AuthoringTool.showErrorDialog(Messages.getString("Error_while_printing_"), e);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        try {
            this.styledStreamTextPane.document.insertString(this.styledStreamTextPane.endPosition.getOffset() - 1, new String(buf, off, len, StyleStream.detectEncoding(buf)), this.style);
        }
        catch (BadLocationException e) {
            AuthoringTool.showErrorDialog(Messages.getString("Error_while_printing_"), e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String detectEncoding(byte[] bytes) {
        String DEFAULT_ENCODING = "UTF-8";
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(bytes, 0, bytes.length);
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        detector.reset();
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        return encoding;
    }
}

