/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyleStream;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class StyledStreamTextPane
extends JTextPane {
    public Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
    public Style stdOutStyle;
    public Style stdErrStyle;
    DefaultStyledDocument document = new DefaultStyledDocument();
    Position endPosition;
    StyleStream defaultStream;
    protected final MouseListener mouseListener = new CustomMouseAdapter(){

        @Override
        protected void popupResponse(MouseEvent e) {
            JPopupMenu popup = this.createPopup();
            popup.show(e.getComponent(), e.getX(), e.getY());
            PopupMenuUtilities.ensurePopupIsOnScreen(popup);
        }

        private JPopupMenu createPopup() {
            Runnable clearAllRunnable = new Runnable(){

                @Override
                public void run() {
                    StyledStreamTextPane.this.setText("");
                }
            };
            Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
            structure.add(new StringObjectPair(Messages.getString("Clear_All"), clearAllRunnable));
            return PopupMenuUtilities.makePopupMenu(structure);
        }
    };

    public StyledStreamTextPane() {
        this.setDocument(this.document);
        this.endPosition = this.document.getEndPosition();
        StyleConstants.setFontFamily(this.defaultStyle, "Monospaced");
        this.stdOutStyle = this.addStyle("stdOut", this.defaultStyle);
        this.stdErrStyle = this.addStyle("stdErr", this.defaultStyle);
        StyleConstants.setForeground(this.stdErrStyle, AuthoringToolResources.getColor("stdErrTextColor"));
        this.defaultStream = this.getNewStyleStream(this.defaultStyle);
        this.setDropTarget(new DropTarget(this, new OutputDropTargetListener()));
        this.addMouseListener(this.mouseListener);
    }

    public StyleStream getNewStyleStream(Style style) {
        try {
            return new StyleStream(this, style);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        if (parent != null) {
            int preferredWidth = this.getUI().getPreferredSize((JComponent)this).width;
            int parentWidth = parent.getSize().width;
            return preferredWidth < parentWidth;
        }
        return false;
    }

    class OutputDropTargetListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Object transferredObject;
            Transferable transferable = dtde.getTransferable();
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementPrototypeReferenceTransferable.elementPrototypeReferenceFlavor)) {
                try {
                    dtde.acceptDrop(0x40000000);
                    ElementPrototype elementPrototype = (ElementPrototype)transferable.getTransferData(ElementPrototypeReferenceTransferable.elementPrototypeReferenceFlavor);
                    if (elementPrototype.getDesiredProperties().length > 0) {
                        PopupItemFactory factory = new PopupItemFactory(){

                            @Override
                            public Object createItem(final Object object) {
                                return new Runnable(){

                                    @Override
                                    public void run() {
                                        if (object instanceof ElementPrototype) {
                                            Element e = ((ElementPrototype)object).createNewElement();
                                            if (e instanceof Question) {
                                                ((OutputDropTargetListener)(this).OutputDropTargetListener.this).StyledStreamTextPane.this.defaultStream.println(((Question)e).getValue());
                                            } else {
                                                ((OutputDropTargetListener)(this).OutputDropTargetListener.this).StyledStreamTextPane.this.defaultStream.println(e);
                                            }
                                        } else {
                                            ((OutputDropTargetListener)(this).OutputDropTargetListener.this).StyledStreamTextPane.this.defaultStream.println(object);
                                        }
                                    }
                                };
                            }
                        };
                        Vector structure = PopupMenuUtilities.makePrototypeStructure(elementPrototype, factory, null);
                        JPopupMenu popup = PopupMenuUtilities.makePopupMenu(structure);
                        popup.show(StyledStreamTextPane.this, (int)dtde.getLocation().getX(), (int)dtde.getLocation().getY());
                        PopupMenuUtilities.ensurePopupIsOnScreen(popup);
                    } else {
                        Element e = elementPrototype.createNewElement();
                        if (e instanceof Question) {
                            StyledStreamTextPane.this.defaultStream.println(((Question)e).getValue());
                        } else {
                            StyledStreamTextPane.this.defaultStream.println(e);
                        }
                    }
                    dtde.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (UnsupportedFlavorException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Drop_didn_t_work__bad_flavor"), e);
                }
                catch (IOException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Drop_didn_t_work__IOException"), e);
                }
            }
            if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, DataFlavor.stringFlavor)) {
                try {
                    dtde.acceptDrop(1);
                    transferredObject = transferable.getTransferData(DataFlavor.stringFlavor);
                    StyledStreamTextPane.this.defaultStream.println(transferredObject);
                    dtde.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (UnsupportedFlavorException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Drop_didn_t_work__bad_flavor"), e);
                }
                catch (IOException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Drop_didn_t_work__IOException"), e);
                }
            } else if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, DataFlavor.getTextPlainUnicodeFlavor())) {
                try {
                    dtde.acceptDrop(1);
                    transferredObject = DataFlavor.getTextPlainUnicodeFlavor().getReaderForText(transferable);
                    StyledStreamTextPane.this.defaultStream.println(transferredObject);
                    final BufferedReader fileReader = new BufferedReader((Reader)transferredObject);
                    Thread fileReaderThread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                String line;
                                while ((line = fileReader.readLine()) != null) {
                                    ((OutputDropTargetListener)OutputDropTargetListener.this).StyledStreamTextPane.this.defaultStream.println(line);
                                }
                                fileReader.close();
                            }
                            catch (IOException e) {
                                AuthoringTool.showErrorDialog(Messages.getString("Error_reading_file_"), e);
                            }
                        }
                    };
                    fileReaderThread.start();
                    dtde.getDropTargetContext().dropComplete(true);
                    fileReader.close();
                    return;
                }
                catch (UnsupportedFlavorException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Drop_didn_t_work__bad_flavor"), e);
                }
                catch (IOException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Drop_didn_t_work__IOException"), e);
                }
            }
            dtde.rejectDrop();
            dtde.getDropTargetContext().dropComplete(true);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }
    }
}

