/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.ChildChangeUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.StencilStateCapsule;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoableRedoable;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class WorldDifferencesCapsule
implements PropertyListener,
ObjectArrayPropertyListener,
ChildrenListener,
AuthoringToolStateListener {
    protected AuthoringTool authoringTool;
    protected World world;
    protected HashMap changedProperties = new HashMap();
    protected ArrayList changedObjectArrayProperties = new ArrayList();
    protected ArrayList changedElements = new ArrayList();
    protected HashMap changedElementPositions = new HashMap();
    protected ArrayList changeOrder = new ArrayList();
    protected boolean isListening;
    protected static final String elementChange = "elementChange";
    protected static final String propertyChange = "propertyChange";
    protected static final String objectArrayChange = "objectArrayChange";
    protected Object preChangeValue;

    public WorldDifferencesCapsule(AuthoringTool authoringTool, World world) {
        this.authoringTool = authoringTool;
        this.world = world;
        this.startListening();
    }

    public StencilStateCapsule getStateCapsule() {
        StencilStateCapsule capsule = new StencilStateCapsule();
        Iterator<Object> iter = this.changedElements.iterator();
        for (Object obj : this.changedObjectArrayProperties) {
            if (!(obj instanceof ObjectArrayPropertyUndoableRedoable)) continue;
            int type = ((ObjectArrayPropertyUndoableRedoable)obj).changeType;
            int oldPos = ((ObjectArrayPropertyUndoableRedoable)obj).oldIndex;
            int newPos = ((ObjectArrayPropertyUndoableRedoable)obj).newIndex;
            Object o = ((ObjectArrayPropertyUndoableRedoable)obj).value;
            Element value = null;
            if (o instanceof Element) {
                value = (Element)o;
            }
            o = ((ObjectArrayPropertyUndoableRedoable)obj).getAffectedObject();
            Element affected = null;
            if (o instanceof Element) {
                affected = (Element)o;
            }
            if (type == 1) {
                capsule.addExistantElement(value.getKey(this.world));
                capsule.putElementPosition(value.getKey(this.world), newPos);
                if (value instanceof CallToUserDefinedResponse) {
                    Variable[] vars;
                    Property params = value.getPropertyNamed("requiredActualParameters");
                    Object udobj = params.getValue();
                    if (!(udobj instanceof Variable[]) || (vars = (Variable[])udobj) == null) continue;
                    int i = 0;
                    while (i < vars.length) {
                        String valueRepr = AuthoringToolResources.getReprForValue(vars[i].getValue(), true);
                        capsule.putPropertyValue(vars[i].getKey(this.world), valueRepr);
                        ++i;
                    }
                    continue;
                }
                String[] visProps = AuthoringToolResources.getInitialVisibleProperties(value.getClass());
                if (visProps == null) continue;
                int i = 0;
                while (i < visProps.length) {
                    Property visProp = ((Response)value).getPropertyNamed(visProps[i]);
                    String valueRepr = AuthoringToolResources.getReprForValue(visProp.get(), true);
                    capsule.putPropertyValue(String.valueOf(value.getKey(this.world)) + "." + visProp.getName(), valueRepr);
                    ++i;
                }
                continue;
            }
            if (type == 2) {
                capsule.putElementPosition(value.getKey(this.world), newPos);
                continue;
            }
            if (this.world.isAncestorOf(value)) continue;
            capsule.addNonExistantElement(value.getKey());
        }
        for (Object o : this.changedProperties.keySet()) {
            String keyAndProp = (String)o;
            int lastPd = keyAndProp.lastIndexOf(".");
            String key = keyAndProp.substring(0, lastPd);
            String propName = keyAndProp.substring(lastPd + 1, keyAndProp.length());
            if (propName.indexOf("data") != -1) continue;
            Element e = this.world.getDescendantKeyed(key);
            Property p = null;
            if (e != null) {
                p = e.getPropertyNamed(propName);
            }
            if (p == null) continue;
            if (p.get() instanceof CallToUserDefinedResponse) {
                Variable[] vars;
                Property resp = ((CallToUserDefinedResponse)p.get()).getPropertyNamed("userDefinedResponse");
                String valueRepr = AuthoringToolResources.getReprForValue(resp.get(), true);
                capsule.putPropertyValue(String.valueOf(resp.getOwner().getKey(this.world)) + ".userDefinedResponse", valueRepr);
                Property pars = ((CallToUserDefinedResponse)p.get()).getPropertyNamed("requiredActualParameters");
                Object udobj = pars.getValue();
                if (!(udobj instanceof Variable[]) || (vars = (Variable[])udobj) == null) continue;
                int i = 0;
                while (i < vars.length) {
                    valueRepr = AuthoringToolResources.getReprForValue(vars[i].getValue(), true);
                    capsule.putPropertyValue(vars[i].getKey(this.world), valueRepr);
                    ++i;
                }
                continue;
            }
            String valueRepr = AuthoringToolResources.getReprForValue(p.get(), true);
            capsule.putPropertyValue(String.valueOf(key) + "." + propName, valueRepr);
        }
        return capsule;
    }

    public Vector getChangedPropertiesNamed(String propertyName) {
        Vector<Property> props = new Vector<Property>();
        Set changedProps = this.changedProperties.keySet();
        for (String propAndKey : changedProps) {
            int endName = propAndKey.lastIndexOf(".");
            String elName = propAndKey.substring(0, endName);
            String propName = propAndKey.substring(endName + 1, propAndKey.length());
            if (!propAndKey.endsWith(propertyName)) continue;
            Element el = this.world.getDescendantKeyed(elName);
            props.addElement(el.getPropertyNamed(propName));
        }
        return props;
    }

    public boolean otherPropertyChangesMade(Set correctPropertyChangeSet) {
        Set changedProps = this.changedProperties.keySet();
        for (String propAndKey : changedProps) {
            if (propAndKey.endsWith("triggerResponse")) {
                int lastPd = propAndKey.lastIndexOf(".");
                String key = propAndKey.substring(0, lastPd);
                String propName = propAndKey.substring(lastPd + 1, propAndKey.length());
                Element e = this.world.getDescendantKeyed(key);
                Property p = null;
                if (e != null) {
                    p = e.getPropertyNamed(propName);
                }
                if (p.get() instanceof CallToUserDefinedResponse) {
                    Property resp = ((CallToUserDefinedResponse)p.get()).getPropertyNamed("userDefinedResponse");
                    propAndKey = String.valueOf(resp.getOwner().getKey(this.world)) + ".userDefinedResponse";
                }
            }
            if (correctPropertyChangeSet == null || correctPropertyChangeSet.contains(propAndKey)) continue;
            propAndKey.endsWith("data");
            if (propAndKey.endsWith("localTransformation")) {
                return true;
            }
            if (propAndKey.endsWith("name")) {
                return true;
            }
            if (propAndKey.endsWith("isCommentedOut")) {
                return true;
            }
            String key = propAndKey.substring(0, propAndKey.lastIndexOf("."));
            Element e = this.world.getDescendantKeyed(key);
            if (!(e instanceof Behavior)) continue;
            return true;
        }
        return false;
    }

    public boolean otherElementsShifted(Set correctElementsShifted) {
        return false;
    }

    public boolean otherElementsInsertedOrDeleted(String[] insertedNames, String[] deletedNames) {
        List<String> insertedList = Arrays.asList(insertedNames);
        List<String> deletedList = Arrays.asList(deletedNames);
        Vector<String> illegalInserts = new Vector<String>();
        for (Object obj : this.changedObjectArrayProperties) {
            if (!(obj instanceof ObjectArrayPropertyUndoableRedoable)) continue;
            Object o = ((ObjectArrayPropertyUndoableRedoable)obj).value;
            int type = ((ObjectArrayPropertyUndoableRedoable)obj).changeType;
            Element e = (Element)o;
            String name = "";
            name = e.isDescendantOf(this.world) ? e.getKey(this.world) : e.getKey();
            if (!insertedList.contains(name) && type == 1) {
                illegalInserts.addElement(name);
            }
            if (deletedList.contains(name) || type != 3 || !illegalInserts.contains(name)) continue;
            illegalInserts.remove(name);
        }
        boolean insertsStillPresent = false;
        int i = 0;
        while (i < illegalInserts.size()) {
            Element e = this.world.getDescendantKeyed((String)illegalInserts.elementAt(i));
            if (e != null) {
                insertsStillPresent = true;
            }
            ++i;
        }
        return insertsStillPresent;
    }

    public synchronized void restoreWorld() {
        this.setIsListening(false);
        Iterator elementIterator = this.changedElements.iterator();
        Iterator objectArrayIterator = this.changedObjectArrayProperties.iterator();
        for (String changeType : this.changeOrder) {
            if (changeType.equals(elementChange)) {
                if (!elementIterator.hasNext()) continue;
                ((UndoableRedoable)elementIterator.next()).undo();
                continue;
            }
            if (!changeType.equals(objectArrayChange) || !objectArrayIterator.hasNext()) continue;
            ((UndoableRedoable)objectArrayIterator.next()).undo();
        }
        for (String propertyKey : this.changedProperties.keySet()) {
            Object oldValue = this.changedProperties.get(propertyKey);
            int dotIndex = propertyKey.lastIndexOf(".");
            String elementKey = propertyKey.substring(0, dotIndex);
            String propertyName = propertyKey.substring(dotIndex + 1);
            Element propertyOwner = this.world.getDescendantKeyed(elementKey);
            if (propertyOwner == null) continue;
            Property property = propertyOwner.getPropertyNamed(propertyName);
            property.set(oldValue);
        }
        this.clear();
        this.setIsListening(true);
    }

    public synchronized void startListening() {
        this.authoringTool.addAuthoringToolStateListener(this);
        this.listenTo(this.world);
        this.setIsListening(true);
    }

    public synchronized void stopListening() {
        this.authoringTool.removeAuthoringToolStateListener(this);
        this.stopListeningTo(this.world);
        this.setIsListening(false);
    }

    public synchronized void dispose() {
        this.clear();
        this.stopListening();
        this.authoringTool = null;
        this.world = null;
    }

    public synchronized void setWorld(World world) {
        if (this.world != null) {
            this.stopListeningTo(this.world);
        }
        this.world = world;
        this.listenTo(world);
    }

    public synchronized void clear() {
        this.changedProperties.clear();
        this.changedObjectArrayProperties.clear();
        this.changedElements.clear();
    }

    protected synchronized void setIsListening(boolean isListening) {
        this.isListening = isListening;
    }

    @Override
    public synchronized void propertyChanging(PropertyEvent propertyEvent) {
        if (this.isListening) {
            Property property = propertyEvent.getProperty();
            this.preChangeValue = propertyEvent.getProperty().get();
        }
    }

    @Override
    public synchronized void propertyChanged(PropertyEvent propertyEvent) {
        if (this.isListening) {
            Property property = propertyEvent.getProperty();
            String propertyRepr = String.valueOf(property.getOwner().getKey(this.world)) + "." + property.getName();
            if (this.changedProperties.containsKey(propertyRepr)) {
                if (AuthoringToolResources.equals(property.get(), this.changedProperties.get(propertyRepr))) {
                    this.changedProperties.remove(propertyRepr);
                }
            } else {
                this.changedProperties.put(propertyRepr, this.preChangeValue);
            }
        }
    }

    @Override
    public synchronized void objectArrayPropertyChanging(ObjectArrayPropertyEvent ev) {
    }

    @Override
    public synchronized void objectArrayPropertyChanged(ObjectArrayPropertyEvent ev) {
        if (this.isListening) {
            this.changedObjectArrayProperties.add(0, new ObjectArrayPropertyUndoableRedoable(ev.getObjectArrayProperty(), ev.getChangeType(), ev.getOldIndex(), ev.getNewIndex(), ev.getItem()));
            this.changeOrder.add(0, objectArrayChange);
        }
    }

    @Override
    public synchronized void childrenChanging(ChildrenEvent childrenEvent) {
    }

    @Override
    public synchronized void childrenChanged(ChildrenEvent childrenEvent) {
        if (this.isListening) {
            this.changedElements.add(0, new ChildChangeUndoableRedoable(childrenEvent));
            this.changeOrder.add(0, elementChange);
            int changeType = childrenEvent.getChangeType();
            if (changeType == 1) {
                this.listenTo(childrenEvent.getChild());
            } else if (changeType == 3) {
                this.stopListeningTo(childrenEvent.getChild());
            }
        }
    }

    public synchronized void listenTo(Element element) {
        if (element != null) {
            Element[] elements = element.getDescendants();
            int i = 0;
            while (i < elements.length) {
                Property[] properties = elements[i].getProperties();
                int j = 0;
                while (j < properties.length) {
                    if (properties[j] instanceof ObjectArrayProperty) {
                        ((ObjectArrayProperty)properties[j]).addObjectArrayPropertyListener(this);
                    } else {
                        properties[j].addPropertyListener(this);
                    }
                    ++j;
                }
                boolean alreadyChildrenListening = false;
                ChildrenListener[] childrenListeners = elements[i].getChildrenListeners();
                int j2 = 0;
                while (j2 < childrenListeners.length) {
                    if (childrenListeners[j2] == this) {
                        alreadyChildrenListening = true;
                    }
                    ++j2;
                }
                if (!alreadyChildrenListening) {
                    elements[i].addChildrenListener(this);
                }
                ++i;
            }
        }
    }

    public synchronized void stopListeningTo(Element element) {
        if (element != null) {
            Element[] elements = element.getDescendants();
            int i = 0;
            while (i < elements.length) {
                Property[] properties = elements[i].getProperties();
                int j = 0;
                while (j < properties.length) {
                    if (properties[j] instanceof ObjectArrayProperty) {
                        ((ObjectArrayProperty)properties[j]).removeObjectArrayPropertyListener(this);
                    } else {
                        properties[j].removePropertyListener(this);
                    }
                    ++j;
                }
                elements[i].removeChildrenListener(this);
                ++i;
            }
        }
    }

    @Override
    public void stateChanged(AuthoringToolStateChangedEvent ev) {
        if (ev.getCurrentState() == 3) {
            this.setIsListening(false);
        } else {
            this.setIsListening(true);
        }
    }

    @Override
    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void stateChanging(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarted(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopped(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPaused(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaved(AuthoringToolStateChangedEvent ev) {
    }
}

