/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WorldFileChooser
extends JFileChooser
implements PropertyChangeListener {
    public WorldFileChooser() {
        this.addPropertyChangeListener("directoryChanged", this);
    }

    @Override
    public void approveSelection() {
        if (this.getDialogType() == 0) {
            File worldDir = this.getSelectedFile();
            File worldFile = new File(worldDir, "elementData.xml");
            if (!worldFile.exists()) {
                DialogManager.showMessageDialog(Messages.getString("Your_selection_is_not_a_valid_world_folder_"));
            } else if (!worldFile.canRead()) {
                DialogManager.showMessageDialog(Messages.getString("Cannot_read_world_from_disk___Access_denied_"));
            } else if (!this.isWorld(worldFile)) {
                DialogManager.showMessageDialog(Messages.getString("Your_selection_is_not_a_valid_world_folder_"));
            } else {
                super.approveSelection();
            }
        } else if (this.getDialogType() == 1) {
            File worldDir = this.getSelectedFile();
            File worldFile = new File(worldDir, "elementData.xml");
            if (worldFile.exists()) {
                int retVal = DialogManager.showConfirmDialog(String.valueOf(Messages.getString("A_World_already_exists_in_")) + worldDir.getAbsolutePath() + Messages.getString("__nWould_you_like_to_replace_it_"), Messages.getString("Replace_World_"), 0);
                if (retVal == 0) {
                    super.approveSelection();
                }
            } else {
                super.approveSelection();
            }
        } else {
            super.approveSelection();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        File worldFile;
        File currentDirectory = (File)ev.getNewValue();
        if (currentDirectory != null && currentDirectory.canRead() && (worldFile = new File(currentDirectory, "elementData.xml")).exists() && worldFile.canRead() && this.isWorld(worldFile)) {
            this.setCurrentDirectory(currentDirectory.getParentFile());
            this.setSelectedFile(currentDirectory);
            this.approveSelection();
        }
    }

    protected boolean isWorld(File xmlFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(xmlFile);
            Element rootElement = document.getDocumentElement();
            rootElement.normalize();
            String className = rootElement.getAttribute("class");
            return className != null && className.trim().equals("edu.cmu.cs.stage3.alice.core.World");
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

