/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.TreeModelSupport;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.IllegalNameValueException;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.lang.Messages;
import java.util.LinkedList;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WorldTreeModel
extends TreeModelSupport
implements AuthoringToolStateListener,
TreeModel {
    protected Element root;
    protected Object[] emptyPath = new Object[]{new World()};
    protected ChildrenListener childrenListener = new ChildrenListener();
    protected NameListener nameListener = new NameListener();
    protected Element currentScope;

    public World HACK_getOriginalRoot() {
        return (World)this.emptyPath[0];
    }

    public Element getCurrentScope() {
        return this.currentScope;
    }

    public void setCurrentScope(Element scope) {
        this.currentScope = scope;
    }

    public boolean isElementInScope(Element element) {
        if (this.currentScope != null) {
            if (element == this.currentScope) {
                return true;
            }
            if (element.isDescendantOf(this.currentScope)) {
                return true;
            }
        }
        return false;
    }

    public void setRoot(Element root) {
        this.stopListeningToTree(this.root);
        this.root = root;
        this.startListeningToTree(root);
        if (root == null) {
            TreeModelEvent ev = new TreeModelEvent((Object)this, this.emptyPath);
            this.fireTreeStructureChanged(ev);
        } else {
            TreeModelEvent ev = new TreeModelEvent((Object)this, this.getPath(root));
            this.fireTreeStructureChanged(ev);
        }
    }

    public Object[] getPath(Element element) {
        LinkedList<Element> list = new LinkedList<Element>();
        Element e = element;
        while (true) {
            if (e == null) {
                return this.emptyPath;
            }
            list.addFirst(e);
            if (e == this.root) break;
            e = e.getParent();
        }
        if (list.isEmpty()) {
            return this.emptyPath;
        }
        return list.toArray();
    }

    public void setListeningEnabled(boolean enabled) {
        if (enabled) {
            this.startListeningToTree(this.root);
        } else {
            this.stopListeningToTree(this.root);
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == null) {
            return true;
        }
        if (node == this.root) {
            return false;
        }
        return this.getChildCount(node) <= 0;
    }

    @Override
    public int getChildCount(Object parent) {
        if (!(parent instanceof Element)) {
            throw new IllegalArgumentException(Messages.getString("nodes_must_be_edu_cmu_cs_stage3_alice_core_Elements"));
        }
        int childCount = 0;
        Element element = (Element)parent;
        String[] childrenProperties = AuthoringToolResources.getWorldTreeChildrenPropertiesStructure(element.getClass());
        if (childrenProperties != null) {
            int i = 0;
            while (i < childrenProperties.length) {
                ObjectArrayProperty oap;
                Property p = element.getPropertyNamed(childrenProperties[i]);
                if (p instanceof ObjectArrayProperty && Element.class.isAssignableFrom((oap = (ObjectArrayProperty)p).getComponentType())) {
                    int j = 0;
                    while (j < oap.size()) {
                        if (element.hasChild((Element)oap.get(j))) {
                            ++childCount;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return childCount;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (!(parent instanceof Element)) {
            throw new IllegalArgumentException(Messages.getString("nodes_must_be_edu_cmu_cs_stage3_alice_core_Elements"));
        }
        int childCount = 0;
        Element element = (Element)parent;
        String[] childrenProperties = AuthoringToolResources.getWorldTreeChildrenPropertiesStructure(element.getClass());
        if (childrenProperties != null) {
            int i = 0;
            while (i < childrenProperties.length) {
                ObjectArrayProperty oap;
                Property p = element.getPropertyNamed(childrenProperties[i]);
                if (p instanceof ObjectArrayProperty && Element.class.isAssignableFrom((oap = (ObjectArrayProperty)p).getComponentType())) {
                    int j = 0;
                    while (j < oap.size()) {
                        if (element.hasChild((Element)oap.get(j))) {
                            if (childCount == index) {
                                return oap.get(j);
                            }
                            ++childCount;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null) {
            return -1;
        }
        if (!(parent instanceof Element)) {
            throw new IllegalArgumentException(Messages.getString("nodes_must_be_edu_cmu_cs_stage3_alice_core_Elements"));
        }
        if (!(child instanceof Element)) {
            throw new IllegalArgumentException(Messages.getString("nodes_must_be_edu_cmu_cs_stage3_alice_core_Elements"));
        }
        int childCount = 0;
        Element element = (Element)parent;
        String[] childrenProperties = AuthoringToolResources.getWorldTreeChildrenPropertiesStructure(element.getClass());
        if (childrenProperties != null) {
            int i = 0;
            while (i < childrenProperties.length) {
                ObjectArrayProperty oap;
                Property p = element.getPropertyNamed(childrenProperties[i]);
                if (p instanceof ObjectArrayProperty && Element.class.isAssignableFrom((oap = (ObjectArrayProperty)p).getComponentType())) {
                    int j = 0;
                    while (j < oap.size()) {
                        if (element.hasChild((Element)oap.get(j))) {
                            if (child == oap.get(j)) {
                                return childCount;
                            }
                            ++childCount;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        if (path.getLastPathComponent() instanceof Element && newValue instanceof String) {
            Element element = (Element)path.getLastPathComponent();
            Object previousName = element.name.get();
            try {
                element.name.set(newValue);
            }
            catch (IllegalNameValueException e) {
                AuthoringTool.showErrorDialog(e.getMessage(), e);
                element.name.set(previousName);
            }
        } else {
            throw new RuntimeException(Messages.getString("only_allows_name_changes_through_the_model"));
        }
    }

    @Override
    public void stateChanging(AuthoringToolStateChangedEvent ev) {
        if (ev.getCurrentState() == 3) {
            this.setListeningEnabled(false);
        } else {
            this.setListeningEnabled(true);
        }
    }

    @Override
    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void stateChanged(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarted(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopped(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPaused(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaved(AuthoringToolStateChangedEvent ev) {
    }

    protected void startListeningToTree(Element element) {
        if (element != null) {
            element.name.addPropertyListener(this.nameListener);
            String[] childrenProperties = AuthoringToolResources.getWorldTreeChildrenPropertiesStructure(element.getClass());
            if (childrenProperties != null) {
                int i = 0;
                while (i < childrenProperties.length) {
                    ObjectArrayProperty oap;
                    Property p = element.getPropertyNamed(childrenProperties[i]);
                    if (p instanceof ObjectArrayProperty && Element.class.isAssignableFrom((oap = (ObjectArrayProperty)p).getComponentType())) {
                        oap.addObjectArrayPropertyListener(this.childrenListener);
                        int j = 0;
                        while (j < oap.size()) {
                            if (element.hasChild((Element)oap.get(j))) {
                                this.startListeningToTree((Element)oap.get(j));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void stopListeningToTree(Element element) {
        if (element != null) {
            element.name.removePropertyListener(this.nameListener);
            String[] childrenProperties = AuthoringToolResources.getWorldTreeChildrenPropertiesStructure(element.getClass());
            if (childrenProperties != null) {
                int i = 0;
                while (i < childrenProperties.length) {
                    ObjectArrayProperty oap;
                    Property p = element.getPropertyNamed(childrenProperties[i]);
                    if (p instanceof ObjectArrayProperty && Element.class.isAssignableFrom((oap = (ObjectArrayProperty)p).getComponentType())) {
                        oap.removeObjectArrayPropertyListener(this.childrenListener);
                        int j = 0;
                        while (j < oap.size()) {
                            if (element.hasChild((Element)oap.get(j))) {
                                this.stopListeningToTree((Element)oap.get(j));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected static int getClassDepth(Class superclass, Class subclass) {
        if (!superclass.isAssignableFrom(subclass)) {
            return -1;
        }
        Class temp = subclass;
        int i = 0;
        while (temp != superclass && superclass.isAssignableFrom(temp)) {
            ++i;
            temp = temp.getSuperclass();
        }
        return i;
    }

    public class ChildrenListener
    implements ObjectArrayPropertyListener {
        @Override
        public void objectArrayPropertyChanging(ObjectArrayPropertyEvent ev) {
        }

        @Override
        public void objectArrayPropertyChanged(ObjectArrayPropertyEvent ev) {
            Element element = (Element)ev.getItem();
            Element parent = ev.getObjectArrayProperty().getOwner();
            Object[] path = WorldTreeModel.this.getPath(parent);
            if (ev.getChangeType() == 1) {
                if (element.getParent() == parent) {
                    WorldTreeModel.this.startListeningToTree(element);
                    int[] childIndices = new int[]{WorldTreeModel.this.getIndexOfChild(parent, element)};
                    Object[] children = new Object[]{element};
                    TreeModelEvent tmev = new TreeModelEvent((Object)this, path);
                    WorldTreeModel.this.fireTreeStructureChanged(tmev);
                }
            } else if (ev.getChangeType() == 3) {
                WorldTreeModel.this.stopListeningToTree(element);
                TreeModelEvent tmev = new TreeModelEvent((Object)this, path);
                WorldTreeModel.this.fireTreeStructureChanged(tmev);
            } else if (ev.getChangeType() == 2) {
                TreeModelEvent tmev = new TreeModelEvent((Object)this, path);
                WorldTreeModel.this.fireTreeStructureChanged(tmev);
            }
        }
    }

    public class NameListener
    implements PropertyListener {
        @Override
        public void propertyChanging(PropertyEvent ev) {
        }

        @Override
        public void propertyChanged(PropertyEvent ev) {
            Element element = ev.getProperty().getOwner();
            Element parent = element.getParent();
            Object[] path = WorldTreeModel.this.getPath(parent);
            int[] childIndices = new int[]{WorldTreeModel.this.getIndexOfChild(parent, element)};
            Object[] children = new Object[]{element};
            if (path == null || path.length == 0) {
                path = WorldTreeModel.this.getPath(element);
                childIndices = null;
                children = null;
            }
            TreeModelEvent tmev = new TreeModelEvent((Object)this, path, childIndices, children);
            WorldTreeModel.this.fireTreeNodesChanged(tmev);
        }
    }
}

