/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.CollectionEditorPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.core.Collection;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class CollectionPropertyViewController
extends JButton
implements GUIElement,
Releasable {
    protected Property property;
    protected boolean omitPropertyName;
    protected PropertyListener propertyListener = new PropertyListener(){

        @Override
        public void propertyChanging(PropertyEvent ev) {
        }

        @Override
        public void propertyChanged(PropertyEvent ev) {
            CollectionPropertyViewController.this.refreshGUI();
        }
    };

    public CollectionPropertyViewController() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (CollectionPropertyViewController.this.property != null) {
                    CollectionEditorPanel collectionEditorPanel = GUIFactory.getCollectionEditorPanel();
                    collectionEditorPanel.setCollection((Collection)CollectionPropertyViewController.this.property.getValue());
                    DialogManager.showMessageDialog(collectionEditorPanel, Messages.getString("Collection_Editor"), -1);
                }
            }
        });
    }

    public void set(Property property, boolean omitPropertyName) {
        this.clean();
        this.property = property;
        this.omitPropertyName = omitPropertyName;
        this.setBackground(AuthoringToolResources.getColor("propertyViewControllerBackground"));
        this.setMargin(new Insets(0, 4, 0, 4));
        this.startListening();
        this.refreshGUI();
    }

    public Property getProperty() {
        return this.property;
    }

    @Override
    public void goToSleep() {
        this.stopListening();
    }

    @Override
    public void wakeUp() {
        this.startListening();
    }

    @Override
    public void clean() {
        this.stopListening();
    }

    @Override
    public void die() {
        this.stopListening();
    }

    @Override
    public void release() {
        GUIFactory.releaseGUI(this);
    }

    public void startListening() {
        if (this.property != null) {
            this.property.addPropertyListener(this.propertyListener);
            if (this.property.getValue() != null) {
                ((Collection)this.property.getValue()).values.addPropertyListener(this.propertyListener);
            }
        }
    }

    public void stopListening() {
        if (this.property != null) {
            this.property.removePropertyListener(this.propertyListener);
            if (this.property.getValue() != null) {
                ((Collection)this.property.getValue()).values.removePropertyListener(this.propertyListener);
            }
        }
    }

    protected void refreshGUI() {
        Object value = this.property.get();
        StringBuffer repr = new StringBuffer();
        if (!this.omitPropertyName) {
            repr.append(String.valueOf(AuthoringToolResources.getReprForValue(this.property)) + " = ");
        }
        if (value instanceof Expression) {
            repr.append(AuthoringToolResources.getNameInContext((Element)value, this.property.getOwner()));
        } else if (value == null) {
            repr.append(Messages.getString("_None_"));
        } else if (value instanceof Collection) {
            Object[] items = ((Collection)value).values.getArrayValue();
            if (items != null) {
                int i = 0;
                while (i < items.length) {
                    repr.append(AuthoringToolResources.getReprForValue(items[i]));
                    if (i < items.length - 1) {
                        repr.append(", ");
                    }
                    ++i;
                }
            } else {
                repr.append(Messages.getString("_None_"));
            }
        } else {
            throw new RuntimeException(String.valueOf(Messages.getString("Bad_value__")) + value);
        }
        this.setText(repr.toString());
        this.revalidate();
        this.repaint();
    }

    protected String getHTMLColorString(Color color) {
        String r = Integer.toHexString(color.getRed());
        String g = Integer.toHexString(color.getGreen());
        String b = Integer.toHexString(color.getBlue());
        if (r.length() == 1) {
            r = "0" + r;
        }
        if (g.length() == 1) {
            g = "0" + g;
        }
        if (b.length() == 1) {
            b = "0" + b;
        }
        return new String("#" + r + g + b);
    }

    public void getHTML(StringBuffer toWriteTo) {
        String tempString = "";
        tempString = String.valueOf(tempString) + "<span style=\"background-color: " + this.getHTMLColorString(this.getBackground()) + "\">";
        String labelText = this.getText();
        if (this.getFont().isBold()) {
            tempString = String.valueOf(tempString) + "<b>" + labelText + "</b>";
        }
        if (this.getFont().isItalic()) {
            tempString = String.valueOf(tempString) + "<i>" + labelText + "</i>";
        }
        tempString = String.valueOf(tempString) + "</span>";
        tempString = " " + tempString + " ";
        toWriteTo.append(tempString);
    }
}

