/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.TransferableFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.authoringtool.util.WatcherPanel;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class PropertyDnDPanel
extends DnDGroupingPanel
implements GUIElement,
Releasable {
    protected AuthoringTool authoringTool;
    protected Property property;
    protected JLabel nameLabel = new JLabel();
    protected Vector popupStructure = new Vector();

    public PropertyDnDPanel() {
        this.setBackground(AuthoringToolResources.getColor("propertyDnDPanel"));
        this.add((Component)this.nameLabel, "Center");
        this.addDragSourceComponent(this.nameLabel);
        CustomMouseAdapter mouseListener = new CustomMouseAdapter(){

            @Override
            public void popupResponse(MouseEvent ev) {
                PropertyDnDPanel.this.updatePopupStructure();
                PopupMenuUtilities.createAndShowPopupMenu(PropertyDnDPanel.this.popupStructure, PropertyDnDPanel.this, ev.getX(), ev.getY());
            }
        };
        this.addMouseListener(mouseListener);
        this.nameLabel.addMouseListener(mouseListener);
        this.grip.addMouseListener(mouseListener);
    }

    public void set(AuthoringTool authoringTool, Property property) {
        this.authoringTool = authoringTool;
        this.property = property;
        this.nameLabel.setText(Messages.getString(AuthoringToolResources.getReprForValue(property).replace(" ", "_")));
        String iconName = "types/" + property.getValueClass().getName();
        ImageIcon icon = AuthoringToolResources.getIconForValue(iconName);
        if (icon == null) {
            icon = AuthoringToolResources.getIconForValue("types/other");
        }
        this.setTransferable(TransferableFactory.createTransferable(property));
    }

    public void updatePopupStructure() {
        this.popupStructure.clear();
        final WatcherPanel watcherPanel = this.authoringTool.getWatcherPanel();
        if (watcherPanel.isPropertyBeingWatched(this.property)) {
            this.popupStructure.add(new StringObjectPair(Messages.getString("stop_watching_this_property"), new Runnable(){

                @Override
                public void run() {
                    watcherPanel.removePropertyBeingWatched(PropertyDnDPanel.this.property);
                }
            }));
        } else {
            this.popupStructure.add(new StringObjectPair(Messages.getString("watch_this_property"), new Runnable(){

                @Override
                public void run() {
                    watcherPanel.addPropertyToWatch(PropertyDnDPanel.this.property);
                }
            }));
        }
    }

    @Override
    public void goToSleep() {
    }

    @Override
    public void wakeUp() {
    }

    @Override
    public void clean() {
        this.setTransferable(null);
    }

    @Override
    public void die() {
        this.clean();
    }

    @Override
    public void release() {
        GUIFactory.releaseGUI(this);
    }
}

