/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyViewController;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ResponsePropertyViewController
extends PropertyViewController {
    protected JLabel responseLabel = new JLabel();
    protected GroupingPanel responsePanel = new GroupingPanel();
    protected Element root = null;

    public ResponsePropertyViewController() {
        this.responseLabel.setOpaque(false);
        this.responsePanel.setOpaque(false);
        this.responsePanel.setLayout(new BorderLayout());
        this.responsePanel.setBorder(null);
    }

    public void set(Property property, boolean allowExpressions, boolean omitPropertyName, PopupItemFactory factory) {
        super.set(property, true, allowExpressions, false, omitPropertyName, factory);
        this.setPopupEnabled(true);
        this.refreshGUI();
    }

    @Override
    protected MouseListener getMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                ResponsePropertyViewController.this.popupButton.doClick();
            }
        };
    }

    public void setRoot(Element root) {
        this.root = root;
    }

    @Override
    protected String getHTMLColorString(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return new String("#" + Integer.toHexString(r) + Integer.toHexString(g) + Integer.toHexString(b));
    }

    @Override
    public void getHTML(StringBuffer toWriteTo) {
        boolean isEnabled = false;
        if (this.property.getOwner() instanceof Behavior) {
            isEnabled = ((Behavior)this.property.getOwner()).isEnabled.booleanValue();
        }
        String strikeStart = "";
        String strikeEnd = "";
        if (!isEnabled) {
            strikeStart = "<strike><font color=\"" + this.getHTMLColorString(AuthoringToolResources.getColor("disabledHTMLText")) + "\">";
            strikeEnd = "</font></strike>";
        }
        if (this.responsePanel.getComponentCount() > 0) {
            if (this.responsePanel.getComponent(0) instanceof CompositeElementPanel && this.property.get() instanceof CompositeResponse) {
                CompositeElementPanel compPanel = (CompositeElementPanel)this.responsePanel.getComponent(0);
                int colSpan = CompositeElementEditor.getDepthCount(((CompositeResponse)this.property.get()).componentResponses);
                compPanel.getHTML(toWriteTo, colSpan + 1, true, !isEnabled);
            } else {
                Color bgColor = this.responsePanel.getComponent(0).getBackground();
                if (!isEnabled) {
                    bgColor = AuthoringToolResources.getColor("disabledHTML");
                }
                toWriteTo.append("<tr>\n<td bgcolor=" + this.getHTMLColorString(bgColor) + " style=\"border-left: 1px solid #c0c0c0; border-top: 1px solid #c0c0c0; border-right: 1px solid #c0c0c0; border-bottom: 1px solid #c0c0c0;\">" + strikeStart);
                toWriteTo.append(GUIFactory.getHTMLStringForComponent(this.responsePanel.getComponent(0)));
                toWriteTo.append(String.valueOf(strikeEnd) + "</td>\n</tr>\n");
            }
        } else {
            toWriteTo.append(strikeStart);
            super.getHTML(toWriteTo);
            toWriteTo.append(strikeEnd);
        }
    }

    @Override
    protected void updatePopupStructure() {
        this.popupStructure = PopupMenuUtilities.makePropertyStructure(this.property, this.factory, this.includeDefaults, this.allowExpressions, this.includeOther, this.root);
    }

    @Override
    protected Component getNativeComponent() {
        return this.responsePanel;
    }

    @Override
    protected Class getNativeClass() {
        return Response.class;
    }

    @Override
    protected void updateNativeComponent() {
        this.responsePanel.removeAll();
        Response response = (Response)this.property.get();
        JComponent gui = GUIFactory.getGUI(response);
        this.responsePanel.add((Component)gui, "Center");
    }
}

