/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.decorator.ViewVolumeDecorator;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.RenderTargetProperty;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OffscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTargetFactory;
import java.awt.Image;
import java.awt.Point;

public abstract class Camera
extends Model {
    public final BooleanProperty isLetterboxedAsOpposedToDistorted = new BooleanProperty(this, "isLetterboxedAsOpposedToDistorted", Boolean.TRUE);
    public final NumberProperty nearClippingPlaneDistance = new NumberProperty(this, "nearClippingPlaneDistance", new Double(0.1));
    public final NumberProperty farClippingPlaneDistance = new NumberProperty(this, "farClippingPlaneDistance", new Double(100.0));
    public final RenderTargetProperty renderTarget = new RenderTargetProperty((Element)this, "renderTarget", null);
    public final BooleanProperty isViewVolumeShowing = new BooleanProperty(this, "isViewVolumeShowing", Boolean.FALSE);
    private edu.cmu.cs.stage3.alice.scenegraph.Camera m_sgCamera;
    private ViewVolumeDecorator m_viewVolumeDecorator;

    protected Camera(edu.cmu.cs.stage3.alice.scenegraph.Camera sgCamera) {
        this.m_sgCamera = sgCamera;
        this.m_sgCamera.setParent(this.getSceneGraphTransformable());
        this.m_sgCamera.setBonus(this);
        this.nearClippingPlaneDistance.set(new Double(this.m_sgCamera.getNearClippingPlaneDistance()));
        this.farClippingPlaneDistance.set(new Double(this.m_sgCamera.getFarClippingPlaneDistance()));
        this.m_viewVolumeDecorator = this.createViewVolumeDecorator();
    }

    @Override
    protected void internalRelease(int pass) {
        switch (pass) {
            case 1: {
                this.m_sgCamera.setParent(null);
                this.m_viewVolumeDecorator.internalRelease(1);
                break;
            }
            case 2: {
                this.m_sgCamera.release();
                this.m_sgCamera = null;
                this.m_viewVolumeDecorator.internalRelease(2);
                this.m_viewVolumeDecorator = null;
            }
        }
        super.internalRelease(pass);
    }

    public edu.cmu.cs.stage3.alice.scenegraph.Camera getSceneGraphCamera() {
        return this.m_sgCamera;
    }

    protected abstract ViewVolumeDecorator createViewVolumeDecorator();

    @Override
    protected void nameValueChanged(String value) {
        super.nameValueChanged(value);
        String s = null;
        if (value != null) {
            s = String.valueOf(value) + ".m_sgCamera";
        }
        this.m_sgCamera.setName(s);
    }

    private void nearClippingPlaneDistanceValueChanged(Number value) {
        double d = Double.NaN;
        if (value != null) {
            d = value.doubleValue();
        }
        this.m_sgCamera.setNearClippingPlaneDistance(d);
    }

    private void farClippingPlaneDistanceValueChanged(Number value) {
        double d = Double.NaN;
        if (value != null) {
            d = value.doubleValue();
        }
        this.m_sgCamera.setFarClippingPlaneDistance(d);
    }

    private void renderTargetValueChanging(RenderTarget renderTargetValueToBe) {
        RenderTarget renderTargetValue = (RenderTarget)this.renderTarget.getValue();
        if (renderTargetValue != null) {
            renderTargetValue.removeCamera(this);
        }
    }

    private void renderTargetValueChanged(RenderTarget renderTargetValue) {
        if (renderTargetValue != null) {
            renderTargetValue.addCamera(this);
        }
    }

    private void isViewVolumeShowingValueChanged(Boolean value) {
        if (this.m_viewVolumeDecorator != null) {
            this.m_viewVolumeDecorator.setIsShowing(value);
        }
    }

    @Override
    protected void propertyChanging(Property property, Object value) {
        if (property != this.nearClippingPlaneDistance && property != this.farClippingPlaneDistance) {
            if (property == this.renderTarget) {
                this.renderTargetValueChanging((RenderTarget)value);
            } else if (property != this.isViewVolumeShowing) {
                super.propertyChanging(property, value);
            }
        }
    }

    @Override
    protected void propertyChanged(Property property, Object value) {
        if (property == this.nearClippingPlaneDistance) {
            this.nearClippingPlaneDistanceValueChanged((Number)value);
        } else if (property == this.farClippingPlaneDistance) {
            this.farClippingPlaneDistanceValueChanged((Number)value);
        } else if (property == this.renderTarget) {
            this.renderTargetValueChanged((RenderTarget)value);
        } else if (property == this.isViewVolumeShowing) {
            this.isViewVolumeShowingValueChanged((Boolean)value);
        } else {
            super.propertyChanged(property, value);
        }
    }

    public PickInfo pick(int x, int y) {
        RenderTarget renderTargetValue = (RenderTarget)this.renderTarget.getValue();
        if (renderTargetValue != null) {
            return renderTargetValue.getInternal().pick(x, y, false, true);
        }
        return null;
    }

    public PickInfo pick(Point p) {
        return this.pick(p.x, p.y);
    }

    public Image takePicture(int width, int height) {
        RenderTargetFactory renderTargetFactory;
        Image image = null;
        World world = this.getWorld();
        if (world != null && (renderTargetFactory = world.getRenderTargetFactory()) != null) {
            OffscreenRenderTarget offscreenRenderTarget = renderTargetFactory.createOffscreenRenderTarget();
            offscreenRenderTarget.setSize(width, height);
            offscreenRenderTarget.addCamera(this.getSceneGraphCamera());
            offscreenRenderTarget.clearAndRenderOffscreen();
            image = offscreenRenderTarget.getOffscreenImage();
            offscreenRenderTarget.removeCamera(this.getSceneGraphCamera());
            offscreenRenderTarget.release();
        }
        return image;
    }

    public boolean canSee(Model model, boolean checkForOcclusion) {
        if (model.getSceneGraphVisual().isInProjectionVolumeOf(this.getSceneGraphCamera())) {
            return true;
        }
        int i = 0;
        while (i < model.parts.size()) {
            Object v = model.parts.get(i);
            if (v instanceof Model && this.canSee((Model)v, checkForOcclusion)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

