/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.CodeCopyReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.CopyReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.ReferenceResolver;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.UnresolvablePropertyReferencesException;
import edu.cmu.cs.stage3.alice.core.UnresolvableReferenceException;
import edu.cmu.cs.stage3.alice.core.VariableCriterion;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Component;
import edu.cmu.cs.stage3.alice.core.reference.DefaultReferenceResolver;
import edu.cmu.cs.stage3.alice.core.reference.ObjectArrayPropertyReference;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.HowMuch;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;

public class CopyFactory {
    private ElementCapsule m_capsule;
    private Class m_valueClass;
    private Class HACK_m_hackValueClass;

    public CopyFactory(Element element, Element internalReferenceRoot, Class[] classesToShare, HowMuch howMuch) {
        CopyReferenceGenerator referenceGenerator = element instanceof Response || element instanceof Component ? new CodeCopyReferenceGenerator(internalReferenceRoot, classesToShare) : new CopyReferenceGenerator(internalReferenceRoot, classesToShare);
        this.m_capsule = new ElementCapsule(element, referenceGenerator, classesToShare, howMuch);
        this.m_valueClass = element.getClass();
        this.HACK_m_hackValueClass = null;
        try {
            if (element instanceof Expression) {
                this.HACK_m_hackValueClass = ((Expression)element).getValueClass();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Class getValueClass() {
        return this.m_valueClass;
    }

    public Class HACK_getExpressionValueClass() {
        return this.HACK_m_hackValueClass;
    }

    public Element manufactureCopy(ReferenceResolver referenceResolver, ProgressObserver progressObserver, Element parentToBe) throws UnresolvablePropertyReferencesException {
        return this.m_capsule.manufacture(referenceResolver, progressObserver, parentToBe);
    }

    public Element manufactureCopy(Element externalRoot, Element internalRoot, ProgressObserver progressObserver, Element parentToBe) throws UnresolvablePropertyReferencesException {
        return this.manufactureCopy(new DefaultReferenceResolver(internalRoot, externalRoot), progressObserver, parentToBe);
    }

    public Element manufactureCopy(Element externalRoot, Element internalRoot, ProgressObserver progressObserver) throws UnresolvablePropertyReferencesException {
        return this.manufactureCopy(externalRoot, internalRoot, progressObserver, null);
    }

    public Element manufactureCopy(Element externalRoot, Element internalRoot) throws UnresolvablePropertyReferencesException {
        return this.manufactureCopy(externalRoot, internalRoot, null);
    }

    public Element manufactureCopy(Element externalRoot) throws UnresolvablePropertyReferencesException {
        return this.manufactureCopy(externalRoot, null);
    }

    public String toString() {
        return "edu.cmu.cs.stage3.alice.core.CopyFactory[" + this.m_valueClass + "]";
    }

    private class ElementCapsule {
        private Class m_cls;
        private PropertyCapsule[] m_propertyCapsules;
        private ElementCapsule[] m_childCapsules;

        private ElementCapsule(Element element, ReferenceGenerator referenceGenerator, Class[] classesToShare, HowMuch howMuch) {
            this.m_cls = element.getClass();
            Element[] elementChildren = element.getChildren();
            this.m_childCapsules = new ElementCapsule[elementChildren.length];
            int i = 0;
            while (i < this.m_childCapsules.length) {
                this.m_childCapsules[i] = elementChildren[i].isAssignableToOneOf(classesToShare) ? null : new ElementCapsule(elementChildren[i], referenceGenerator, classesToShare, howMuch);
                ++i;
            }
            Property[] elementProperties = element.getProperties();
            this.m_propertyCapsules = new PropertyCapsule[elementProperties.length];
            int i2 = 0;
            while (i2 < this.m_propertyCapsules.length) {
                this.m_propertyCapsules[i2] = new PropertyCapsule(elementProperties[i2], referenceGenerator);
                ++i2;
            }
        }

        private String getName() {
            int i = 0;
            while (i < this.m_propertyCapsules.length) {
                PropertyCapsule propertyCapsule = this.m_propertyCapsules[i];
                if (propertyCapsule.m_name.equals("name")) {
                    return (String)propertyCapsule.m_value;
                }
                ++i;
            }
            return null;
        }

        private Element internalManufacture(Vector referencesToBeResolved) {
            Element element;
            try {
                element = (Element)this.m_cls.newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException();
            }
            int i = 0;
            while (i < this.m_childCapsules.length) {
                if (this.m_childCapsules[i] != null) {
                    element.addChild(this.m_childCapsules[i].internalManufacture(referencesToBeResolved));
                }
                ++i;
            }
            i = 0;
            while (i < this.m_propertyCapsules.length) {
                this.m_propertyCapsules[i].set(element, referencesToBeResolved);
                ++i;
            }
            return element;
        }

        private Element lookup(Element element, VariableCriterion variableCriterion) {
            if (element != null) {
                int i = 0;
                while (i < element.getChildCount()) {
                    Element child = element.getChildAt(i);
                    if (variableCriterion.accept(child)) {
                        return child;
                    }
                    ++i;
                }
                return this.lookup(element.getParent(), variableCriterion);
            }
            return null;
        }

        private Element manufacture(ReferenceResolver referenceResolver, ProgressObserver progressObserver, Element parentToBe) throws UnresolvablePropertyReferencesException {
            Vector referencesToBeResolved = new Vector();
            Element element = this.internalManufacture(referencesToBeResolved);
            Vector<PropertyReference> referencesLeftUnresolved = new Vector<PropertyReference>();
            element.setParent(parentToBe);
            try {
                DefaultReferenceResolver drr;
                if (referenceResolver instanceof DefaultReferenceResolver && (drr = (DefaultReferenceResolver)referenceResolver).getInternalRoot() == null) {
                    drr.setInternalRoot(element);
                }
                Enumeration enum0 = referencesToBeResolved.elements();
                while (enum0.hasMoreElements()) {
                    PropertyReference propertyReference = (PropertyReference)enum0.nextElement();
                    try {
                        Criterion criterion = propertyReference.getCriterion();
                        if (criterion instanceof VariableCriterion) {
                            VariableCriterion variableCriterion = (VariableCriterion)criterion;
                            Element variable = this.lookup(propertyReference.getProperty().getOwner(), variableCriterion);
                            if (variable == null) continue;
                            propertyReference.getProperty().set(variable);
                            continue;
                        }
                        propertyReference.resolve(referenceResolver);
                    }
                    catch (UnresolvableReferenceException ure) {
                        referencesLeftUnresolved.addElement(propertyReference);
                    }
                }
            }
            finally {
                element.setParent(null);
            }
            if (referencesLeftUnresolved.size() > 0) {
                Object[] propertyReferences = new PropertyReference[referencesLeftUnresolved.size()];
                referencesLeftUnresolved.copyInto(propertyReferences);
                StringBuffer sb = new StringBuffer();
                sb.append("PropertyReferences: \n");
                int i = 0;
                while (i < propertyReferences.length) {
                    sb.append(propertyReferences[i]);
                    sb.append("\n");
                    ++i;
                }
                throw new UnresolvablePropertyReferencesException((PropertyReference[])propertyReferences, element, sb.toString());
            }
            return element;
        }

        private class PropertyCapsule {
            private String m_name;
            private Object m_value;

            private PropertyCapsule(Property property, ReferenceGenerator referenceGenerator) {
                this.m_name = property.getName();
                if (property instanceof ObjectArrayProperty) {
                    ObjectArrayProperty oap = (ObjectArrayProperty)property;
                    if (oap.get() != null) {
                        Object[] array = new Object[oap.size()];
                        int i = 0;
                        while (i < oap.size()) {
                            array[i] = this.getValueToTuckAway(oap.get(i), referenceGenerator);
                            ++i;
                        }
                        this.m_value = array;
                    } else {
                        this.m_value = null;
                    }
                } else {
                    this.m_value = this.getValueToTuckAway(property.get(), referenceGenerator);
                }
            }

            private Object getCopyIfPossible(Object o) {
                if (o instanceof Cloneable) {
                    return o;
                }
                return o;
            }

            private Object getValueToTuckAway(Object value, ReferenceGenerator referenceGenerator) {
                if (value instanceof Element) {
                    return referenceGenerator.generateReference((Element)value);
                }
                return this.getCopyIfPossible(value);
            }

            private Object getValueForCopy(Property property, Object value, Vector referencesToBeResolved) {
                if (value instanceof Criterion) {
                    referencesToBeResolved.addElement(new PropertyReference(property, (Criterion)value));
                    return null;
                }
                return this.getCopyIfPossible(value);
            }

            private Object getValueForCopy(ObjectArrayProperty oap, Object value, int i, Vector referencesToBeResolved) {
                if (value instanceof Criterion) {
                    referencesToBeResolved.addElement(new ObjectArrayPropertyReference(oap, (Criterion)value, i, 0));
                    return null;
                }
                return this.getCopyIfPossible(value);
            }

            public void set(Element element, Vector referencesToBeResolved) {
                Property property = element.getPropertyNamed(this.m_name);
                if (property instanceof ObjectArrayProperty) {
                    ObjectArrayProperty oap = (ObjectArrayProperty)property;
                    if (this.m_value != null) {
                        Object[] src = (Object[])this.m_value;
                        Object[] dst = (Object[])Array.newInstance(oap.getComponentType(), src.length);
                        int i = 0;
                        while (i < src.length) {
                            dst[i] = this.getValueForCopy(oap, src[i], i, referencesToBeResolved);
                            ++i;
                        }
                        oap.set(dst);
                    } else {
                        oap.set(null);
                    }
                } else {
                    property.set(this.getValueForCopy(property, this.m_value, referencesToBeResolved));
                }
            }
        }
    }
}

