/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.util.Enumerable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Direction
extends Enumerable {
    public static final Direction LEFT = new Direction(MathUtilities.createNegativeXAxis(), MathUtilities.createNegativeYAxis(), MathUtilities.createZAxis());
    public static final Direction RIGHT = new Direction(MathUtilities.createXAxis(), MathUtilities.createYAxis(), MathUtilities.createNegativeZAxis());
    public static final Direction UP = new Direction(MathUtilities.createYAxis(), null, null);
    public static final Direction DOWN = new Direction(MathUtilities.createNegativeYAxis(), null, null);
    public static final Direction FORWARD = new Direction(MathUtilities.createZAxis(), MathUtilities.createXAxis(), null);
    public static final Direction BACKWARD = new Direction(MathUtilities.createNegativeZAxis(), MathUtilities.createNegativeXAxis(), null);
    private Vector3d m_moveAxis;
    private Vector3d m_turnAxis;
    private Vector3d m_rollAxis;

    public Direction(Vector3d moveAxis, Vector3d turnAxis, Vector3d rollAxis) {
        this.m_moveAxis = moveAxis;
        this.m_turnAxis = turnAxis;
        this.m_rollAxis = rollAxis;
    }

    public Vector3d getMoveAxis() {
        return this.m_moveAxis;
    }

    public Vector3d getTurnAxis() {
        return this.m_turnAxis;
    }

    public Vector3d getRollAxis() {
        return this.m_rollAxis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Direction) {
            Direction direction = (Direction)o;
            if (this.m_moveAxis != null ? !this.m_moveAxis.equals((Tuple3d)direction.m_moveAxis) : direction.m_moveAxis != null) {
                return false;
            }
            if (this.m_turnAxis != null ? !this.m_turnAxis.equals((Tuple3d)direction.m_turnAxis) : direction.m_turnAxis != null) {
                return false;
            }
            return !(this.m_rollAxis != null ? !this.m_rollAxis.equals((Tuple3d)direction.m_rollAxis) : direction.m_rollAxis != null);
        }
        return false;
    }

    public static Direction valueOf(String s) {
        return (Direction)Enumerable.valueOf(s, Direction.class);
    }
}

