/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.util.Enumerable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class SpatialRelation
extends Enumerable {
    private Vector3d m_placeAxis;
    public static final SpatialRelation LEFT_OF = new SpatialRelation(new Vector3d(-1.0, 0.0, 0.0));
    public static final SpatialRelation RIGHT_OF = new SpatialRelation(new Vector3d(1.0, 0.0, 0.0));
    public static final SpatialRelation ABOVE = new SpatialRelation(new Vector3d(0.0, 1.0, 0.0));
    public static final SpatialRelation BELOW = new SpatialRelation(new Vector3d(0.0, -1.0, 0.0));
    public static final SpatialRelation IN_FRONT_OF = new SpatialRelation(new Vector3d(0.0, 0.0, 1.0));
    public static final SpatialRelation BEHIND = new SpatialRelation(new Vector3d(0.0, 0.0, -1.0));
    public static final SpatialRelation FRONT_RIGHT_OF = new SpatialRelation(new Vector3d(0.7071068, 0.0, 0.7071068));
    public static final SpatialRelation FRONT_LEFT_OF = new SpatialRelation(new Vector3d(-0.7071068, 0.0, 0.7071068));
    public static final SpatialRelation BEHIND_RIGHT_OF = new SpatialRelation(new Vector3d(0.7071068, 0.0, -0.7071068));
    public static final SpatialRelation BEHIND_LEFT_OF = new SpatialRelation(new Vector3d(-0.7071068, 0.0, -0.7071068));

    private SpatialRelation(Vector3d placeAxis) {
        this.m_placeAxis = placeAxis;
    }

    public Vector3d getPlaceVector(double amount, Box subjectBoundingBox, Box objectBoundingBox) {
        double x = amount * this.m_placeAxis.x;
        double y = amount * this.m_placeAxis.y;
        double z = amount * this.m_placeAxis.z;
        if (this.m_placeAxis.x > 0.0) {
            x += this.m_placeAxis.x * (objectBoundingBox.getMaximum().x - subjectBoundingBox.getMinimum().x);
        } else if (this.m_placeAxis.x < 0.0) {
            x += this.m_placeAxis.x * (subjectBoundingBox.getMaximum().x - objectBoundingBox.getMinimum().x);
        }
        if (this.m_placeAxis.y > 0.0) {
            y += this.m_placeAxis.y * (objectBoundingBox.getMaximum().y - subjectBoundingBox.getMinimum().y);
        } else if (this.m_placeAxis.y < 0.0) {
            y += this.m_placeAxis.y * (subjectBoundingBox.getMaximum().y - objectBoundingBox.getMinimum().y);
        }
        if (this.m_placeAxis.z > 0.0) {
            z += this.m_placeAxis.z * (objectBoundingBox.getMaximum().z - subjectBoundingBox.getMinimum().z);
        } else if (this.m_placeAxis.z < 0.0) {
            z += this.m_placeAxis.z * (subjectBoundingBox.getMaximum().z - objectBoundingBox.getMinimum().z);
        }
        return new Vector3d(x, y, z);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof SpatialRelation) {
            SpatialRelation spatialRelation = (SpatialRelation)o;
            if (this.m_placeAxis == null) {
                return spatialRelation.m_placeAxis == null;
            }
            return this.m_placeAxis.equals((Tuple3d)spatialRelation.m_placeAxis);
        }
        return false;
    }

    public static SpatialRelation valueOf(String s) {
        return (SpatialRelation)Enumerable.valueOf(s, SpatialRelation.class);
    }
}

