/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Clock;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.FogStyle;
import edu.cmu.cs.stage3.alice.core.Group;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.bubble.Bubble;
import edu.cmu.cs.stage3.alice.core.bubble.BubbleManager;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.MessageEvent;
import edu.cmu.cs.stage3.alice.core.event.MessageListener;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ColorProperty;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.alice.scenegraph.AmbientLight;
import edu.cmu.cs.stage3.alice.scenegraph.Background;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.ExponentialFog;
import edu.cmu.cs.stage3.alice.scenegraph.LinearFog;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.collision.CollisionManager;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTargetFactory;
import edu.cmu.cs.stage3.alice.scripting.Code;
import edu.cmu.cs.stage3.alice.scripting.CompileType;
import edu.cmu.cs.stage3.alice.scripting.Interpreter;
import edu.cmu.cs.stage3.alice.scripting.ScriptingFactory;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Sphere;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class World
extends ReferenceFrame {
    private static boolean HACK_s_isPropetryListeningDisabledWhileWorldIsRunning = false;
    public final ElementArrayProperty sandboxes = new ElementArrayProperty((Element)this, "sandboxes", null, Sandbox[].class);
    public final ElementArrayProperty groups = new ElementArrayProperty((Element)this, "groups", null, Group[].class);
    public final ColorProperty atmosphereColor = new ColorProperty(this, "atmosphereColor", Color.BLACK);
    public final ColorProperty ambientLightColor = new ColorProperty(this, "ambientLightColor", Color.WHITE);
    public final NumberProperty ambientLightBrightness = new NumberProperty(this, "ambientLightBrightness", new Double(0.2));
    public final ObjectProperty fogStyle = new ObjectProperty(this, "fogStyle", FogStyle.NONE, FogStyle.class);
    public final NumberProperty fogDensity = new NumberProperty(this, "fogDensity", new Double(0.0));
    public final NumberProperty fogNearDistance = new NumberProperty(this, "fogNearDistance", new Double(0.0));
    public final NumberProperty fogFarDistance = new NumberProperty(this, "fogFarDistance", new Double(1.0));
    public final ObjectArrayProperty bubbles = new ObjectArrayProperty((Element)this, "bubbles", null, Bubble[].class);
    public final NumberProperty speedMultiplier = new NumberProperty(this, "speedMultiplier", new Double(1.0));
    private Scene m_sgScene;
    private AmbientLight m_sgAmbientLight;
    private Background m_sgBackground;
    private LinearFog m_sgLinearFog;
    private ExponentialFog m_sgExponentialFog;
    private CollisionManager m_collisionManager = new CollisionManager();
    private Visual[][] m_collisions = new Visual[0][];
    private Vector m_capsulePropertyValuePairs = new Vector();
    private Hashtable m_capsuleElements = new Hashtable();
    private RenderTargetFactory m_renderTargetFactory = null;
    private ScriptingFactory m_scriptingFactory;
    private Interpreter m_interpreter;
    private Vector m_messageListeners = new Vector();
    private MessageListener[] m_messageListenerArray = null;
    private Sandbox m_currentSandbox = null;
    private BubbleManager m_bubbleManager = new BubbleManager();
    private Clock m_clock = null;
    private boolean m_isRunning = false;

    static {
        try {
            HACK_s_isPropetryListeningDisabledWhileWorldIsRunning = Boolean.getBoolean("alice.isPropetryListeningDisabledWhileWorldIsRunning");
        }
        catch (Throwable t) {
            HACK_s_isPropetryListeningDisabledWhileWorldIsRunning = false;
        }
    }

    public World() {
        this.m_sgScene = new Scene();
        this.m_sgScene.setBonus(this);
        this.m_sgBackground = new Background();
        this.m_sgBackground.setBonus(this);
        this.m_sgScene.setBackground(this.m_sgBackground);
        this.m_sgAmbientLight = new AmbientLight();
        this.m_sgAmbientLight.setBonus(this);
        this.m_sgAmbientLight.setParent(this.m_sgScene);
        this.m_sgLinearFog = new LinearFog();
        this.m_sgLinearFog.setBonus(this);
        this.m_sgExponentialFog = new ExponentialFog();
        this.m_sgExponentialFog.setBonus(this);
        this.atmosphereColor.set(this.m_sgBackground.getColor());
        this.ambientLightColor.set(this.m_sgAmbientLight.getColor());
        this.ambientLightBrightness.set(new Double(this.m_sgAmbientLight.getBrightness()));
        this.fogNearDistance.set(new Double(this.m_sgLinearFog.getNearDistance()));
        this.fogFarDistance.set(new Double(this.m_sgLinearFog.getFarDistance()));
        this.fogDensity.set(new Double(this.m_sgExponentialFog.getDensity()));
        this.fogStyle.set(FogStyle.NONE);
    }

    public Clock getClock() {
        return this.m_clock;
    }

    public void setClock(Clock clock) {
        this.m_clock = clock;
    }

    public BubbleManager getBubbleManager() {
        return this.m_bubbleManager;
    }

    private Interpreter getInterpreter() {
        if (this.m_scriptingFactory != null && this.m_interpreter == null) {
            this.m_interpreter = this.m_scriptingFactory.manufactureInterpreter();
            this.m_interpreter.setWorld(this);
        }
        return this.m_interpreter;
    }

    @Override
    public Code compile(String script, Object source, CompileType compileType) {
        return this.getInterpreter().compile(script, source, compileType);
    }

    @Override
    public Object eval(Code code) {
        return this.getInterpreter().eval(code);
    }

    @Override
    public void exec(Code code) {
        this.getInterpreter().exec(code);
    }

    public Visual[][] getCollisions() {
        return this.m_collisions;
    }

    public void addCollisionManagementFor(Transformable t) {
        if (t != null) {
            Visual[] sgVisuals = t.getAllSceneGraphVisuals();
            int i = 0;
            while (i < sgVisuals.length) {
                Sphere sphere = sgVisuals[i].getBoundingSphere();
                if (sphere != null && sphere.getRadius() > 0.0) {
                    this.m_collisionManager.activateObject(sgVisuals[i]);
                }
                ++i;
            }
            i = 0;
            while (i < sgVisuals.length) {
                int j = i + 1;
                while (j < sgVisuals.length) {
                    Sphere sphereJ;
                    Sphere sphereI = sgVisuals[i].getBoundingSphere();
                    if (sphereI != null && sphereI.getRadius() > 0.0 && (sphereJ = sgVisuals[j].getBoundingSphere()) != null && sphereJ.getRadius() > 0.0) {
                        this.m_collisionManager.deactivatePair(sgVisuals[i], sgVisuals[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void removeCollisionManagementFor(Transformable t) {
    }

    @Override
    protected void internalRelease(int pass) {
        switch (pass) {
            case 1: {
                if (this.m_interpreter != null) {
                    this.m_interpreter.release();
                    this.m_interpreter = null;
                }
                if (this.m_sgExponentialFog != null) {
                    this.m_sgExponentialFog.setParent(null);
                }
                if (this.m_sgLinearFog != null) {
                    this.m_sgLinearFog.setParent(null);
                }
                this.m_sgAmbientLight.setParent(null);
                this.m_sgScene.setBackground(null);
                break;
            }
            case 2: {
                this.m_sgScene.release();
                this.m_sgScene = null;
                this.m_sgAmbientLight.release();
                this.m_sgAmbientLight = null;
                this.m_sgBackground.release();
                this.m_sgBackground = null;
                if (this.m_sgExponentialFog != null) {
                    this.m_sgExponentialFog.release();
                    this.m_sgExponentialFog = null;
                }
                if (this.m_sgLinearFog == null) break;
                this.m_sgLinearFog.release();
                this.m_sgLinearFog = null;
            }
        }
        super.internalRelease(pass);
    }

    public Scene getSceneGraphScene() {
        return this.m_sgScene;
    }

    @Override
    public Container getSceneGraphContainer() {
        return this.m_sgScene;
    }

    @Override
    public edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame getSceneGraphReferenceFrame() {
        return this.m_sgScene;
    }

    public AmbientLight getSceneGraphAmbientLight() {
        return this.m_sgAmbientLight;
    }

    public Background getSceneGraphBackground() {
        return this.m_sgBackground;
    }

    public ExponentialFog getSceneGraphExponentialFog() {
        return this.m_sgExponentialFog;
    }

    public LinearFog getSceneGraphLinearFog() {
        return this.m_sgLinearFog;
    }

    @Override
    public void addAbsoluteTransformationListener(AbsoluteTransformationListener absoluteTransformationListener) {
    }

    @Override
    public void removeAbsoluteTransformationListener(AbsoluteTransformationListener absoluteTransformationListener) {
    }

    @Override
    protected void nameValueChanged(String value) {
        super.nameValueChanged(value);
        if (value != null) {
            this.m_sgScene.setName(String.valueOf(value) + ".m_sgScene");
            this.m_sgBackground.setName(String.valueOf(value) + ".m_sgBackground");
            this.m_sgAmbientLight.setName(String.valueOf(value) + ".m_sgAmbientLight");
            this.m_sgExponentialFog.setName(String.valueOf(value) + ".m_sgExponentialFog");
            this.m_sgLinearFog.setName(String.valueOf(value) + ".m_sgLinearFog");
        } else {
            this.m_sgScene.setName(null);
            this.m_sgBackground.setName(null);
            this.m_sgAmbientLight.setName(null);
            this.m_sgExponentialFog.setName(null);
            this.m_sgLinearFog.setName(null);
        }
    }

    protected void atmosphereColorValueChanged(Color value) {
        this.m_sgBackground.setColor(value);
        this.m_sgLinearFog.setColor(value);
        this.m_sgExponentialFog.setColor(value);
    }

    protected void ambientLightColorValueChanged(Color value) {
        this.m_sgAmbientLight.setColor(value);
    }

    protected void ambientLightBrightnessValueChanged(Number value) {
        double d = Double.NaN;
        if (value != null) {
            d = value.doubleValue();
        }
        this.m_sgAmbientLight.setBrightness(d);
    }

    protected void fogDensityValueChanged(Number value) {
        double d = Double.NaN;
        if (value != null) {
            d = value.doubleValue();
        }
        this.m_sgExponentialFog.setDensity(d);
    }

    protected void fogNearDistanceValueChanged(Number value) {
        double d = Double.NaN;
        if (value != null) {
            d = value.doubleValue();
        }
        this.m_sgLinearFog.setNearDistance(d);
    }

    protected void fogFarDistanceValueChanged(Number value) {
        double d = Double.NaN;
        if (value != null) {
            d = value.doubleValue();
        }
        this.m_sgLinearFog.setFarDistance(d);
    }

    protected void fogStyleValueChanged(FogStyle value) {
        if (value == FogStyle.EXPONENTIAL) {
            this.m_sgLinearFog.setParent(null);
            this.m_sgExponentialFog.setParent(this.m_sgScene);
        } else if (value == FogStyle.LINEAR) {
            this.m_sgLinearFog.setParent(this.m_sgScene);
            this.m_sgExponentialFog.setParent(null);
        } else {
            this.m_sgLinearFog.setParent(null);
            this.m_sgExponentialFog.setParent(null);
        }
    }

    @Override
    protected void propertyChanged(Property property, Object value) {
        if (property == this.atmosphereColor) {
            this.atmosphereColorValueChanged((Color)value);
        } else if (property == this.ambientLightColor) {
            this.ambientLightColorValueChanged((Color)value);
        } else if (property == this.ambientLightBrightness) {
            this.ambientLightBrightnessValueChanged((Number)value);
        } else if (property == this.fogStyle) {
            this.fogStyleValueChanged((FogStyle)value);
        } else if (property == this.fogDensity) {
            this.fogDensityValueChanged((Number)value);
        } else if (property == this.fogNearDistance) {
            this.fogNearDistanceValueChanged((Number)value);
        } else if (property == this.fogFarDistance) {
            this.fogFarDistanceValueChanged((Number)value);
        } else if (property == this.bubbles) {
            this.m_bubbleManager.setBubbles((Bubble[])this.bubbles.getArrayValue());
        } else {
            super.propertyChanged(property, value);
        }
    }

    @Override
    public Matrix44 getTransformation(ReferenceFrame asSeenBy) {
        if (asSeenBy == null) {
            return Matrix44.IDENTITY;
        }
        return super.getTransformation(asSeenBy);
    }

    @Override
    protected void internalFindAccessibleExpressions(Class cls, Vector v) {
        int i = 0;
        while (i < this.sandboxes.size()) {
            Sandbox sandbox = (Sandbox)this.sandboxes.get(i);
            int j = 0;
            while (j < sandbox.variables.size()) {
                this.internalAddExpressionIfAssignableTo((Expression)sandbox.variables.get(j), cls, v);
                ++j;
            }
            j = 0;
            while (j < sandbox.questions.size()) {
                this.internalAddExpressionIfAssignableTo((Expression)sandbox.questions.get(j), cls, v);
                ++j;
            }
            ++i;
        }
        super.internalFindAccessibleExpressions(cls, v);
    }

    public ScriptingFactory getScriptingFactory() {
        return this.m_scriptingFactory;
    }

    public void setScriptingFactory(ScriptingFactory scriptingFactory) {
        this.m_scriptingFactory = scriptingFactory;
    }

    public RenderTargetFactory getRenderTargetFactory() {
        return this.m_renderTargetFactory;
    }

    public void setRenderTargetFactory(RenderTargetFactory renderTargetFactory) {
        this.m_renderTargetFactory = renderTargetFactory;
        RenderTarget[] renderTargets = (RenderTarget[])this.getDescendants(RenderTarget.class);
        int i = 0;
        while (i < renderTargets.length) {
            renderTargets[i].commit(this.m_renderTargetFactory);
            ++i;
        }
    }

    public void sendMessage(Element source, String message, Transformable fromWho, Transformable toWhom, long when) {
        MessageEvent messageEvent = new MessageEvent(source, message, fromWho, toWhom, when);
        int i = 0;
        while (i < this.m_messageListeners.size()) {
            MessageListener messageListener = (MessageListener)this.m_messageListeners.elementAt(i);
            messageListener.messageSent(messageEvent);
            ++i;
        }
    }

    public void addMessageListener(MessageListener messageListener) {
        this.m_messageListeners.addElement(messageListener);
        this.m_messageListenerArray = null;
    }

    public void removeMessageListener(MessageListener messageListener) {
        this.m_messageListeners.removeElement(messageListener);
        this.m_messageListenerArray = null;
    }

    public MessageListener[] getMessageListeners() {
        if (this.m_messageListenerArray == null) {
            this.m_messageListenerArray = new MessageListener[this.m_messageListeners.size()];
            this.m_messageListeners.copyInto(this.m_messageListenerArray);
        }
        return this.m_messageListenerArray;
    }

    public void preserve() {
        this.m_capsulePropertyValuePairs.clear();
        this.m_capsuleElements.clear();
        Element[] elements = this.getDescendants();
        int i = 0;
        while (i < elements.length) {
            Element element = elements[i];
            ChildrenListener[] childrenListeners = element.getChildrenListeners();
            if (childrenListeners != null && childrenListeners.length != 0) {
                World.warnln("WARNING: " + element.getKey() + " has CHILDREN listeners: ");
                int j = 0;
                while (j < childrenListeners.length) {
                    World.warnln("\t" + childrenListeners[j].getClass());
                    ++j;
                }
            }
            this.m_capsuleElements.put(element, Boolean.TRUE);
            Property[] properties = element.getProperties();
            int j = 0;
            while (j < properties.length) {
                ObjectArrayProperty objectArrayPropery;
                ObjectArrayPropertyListener[] objectArrayProperyListeners;
                Property property = properties[j];
                PropertyListener[] propertyListeners = property.getPropertyListeners();
                if (propertyListeners != null && propertyListeners.length != 0) {
                    World.warnln("WARNING: " + element.getKey() + "." + property.getName() + " has PROPERTY listeners: ");
                    int k = 0;
                    while (k < propertyListeners.length) {
                        World.warnln("\t" + propertyListeners[k].getClass());
                        ++k;
                    }
                }
                if (property instanceof ObjectArrayProperty && (objectArrayProperyListeners = (objectArrayPropery = (ObjectArrayProperty)property).getObjectArrayPropertyListeners()) != null && objectArrayProperyListeners.length != 0) {
                    World.warnln("WARNING: " + element.getKey() + "." + objectArrayPropery.getName() + " has OBJECT ARRAY PROPERTY listeners: ");
                    int k = 0;
                    while (k < objectArrayProperyListeners.length) {
                        World.warnln("\t" + objectArrayProperyListeners[k].getClass());
                        ++k;
                    }
                }
                Object[] tuple = new Object[]{property, property.get()};
                this.m_capsulePropertyValuePairs.addElement(tuple);
                ++j;
            }
            ++i;
        }
    }

    public void restore() {
        Element element;
        Enumeration preserves = this.m_capsulePropertyValuePairs.elements();
        while (preserves.hasMoreElements()) {
            Object[] tuple = (Object[])preserves.nextElement();
            Property property = (Property)tuple[0];
            Object value = tuple[1];
            property.set(value);
        }
        Element[] elements = this.getDescendants();
        int i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (this.m_capsuleElements.get(element) == null) {
                element.removeFromParent();
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (this.m_capsuleElements.get(element) == null) {
                element.release();
            }
            ++i;
        }
    }

    @Override
    protected void scheduleBehaviors(double t) {
        super.scheduleBehaviors(t);
        int i = 0;
        while (i < this.sandboxes.size()) {
            this.m_currentSandbox = (Sandbox)this.sandboxes.get(i);
            this.m_currentSandbox.scheduleBehaviors(t);
            ++i;
        }
    }

    public Sandbox getCurrentSandbox() {
        return this.m_currentSandbox;
    }

    public boolean isRunning() {
        return this.m_isRunning;
    }

    public void start() {
        if (HACK_s_isPropetryListeningDisabledWhileWorldIsRunning) {
            Property.HACK_disableListening();
        }
        if (this.m_scriptingFactory != null) {
            this.getInterpreter().start();
            Code code = this.script.getCode(CompileType.EXEC_MULTIPLE);
            if (code != null) {
                this.exec(code);
            }
        }
        this.bubbles.clear();
        this.started(this, this.m_clock.getTime());
        this.m_isRunning = true;
    }

    public void schedule() {
        this.m_currentSandbox = this;
        this.scheduleBehaviors(this.m_clock.getTime());
        this.m_collisions = this.m_collisionManager.update(256);
        this.m_currentSandbox = null;
    }

    public void stop() {
        this.bubbles.clear();
        this.m_isRunning = false;
        if (this.m_scriptingFactory != null) {
            this.getInterpreter().stop();
        }
        this.stopped(this, this.m_clock.getTime());
        if (HACK_s_isPropetryListeningDisabledWhileWorldIsRunning) {
            Property.HACK_enableListening();
        }
    }
}

