/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.ResponseProperty;

public abstract class AbstractConditionalBehavior
extends Behavior {
    public final ResponseProperty beginResponse = new ResponseProperty((Element)this, "beginResponse", null);
    public final ResponseProperty duringResponse = new ResponseProperty((Element)this, "duringResponse", null);
    public final ResponseProperty endResponse = new ResponseProperty((Element)this, "endResponse", null);
    private static final int RUNTIME_STATE_CHECKING_FOR_TRUE = 0;
    private static final int RUNTIME_STATE_BEGINNING = 1;
    private static final int RUNTIME_STATE_CHECKING_FOR_FALSE = 2;
    private static final int RUNTIME_STATE_ENDING = 3;
    private int m_runtimeState = 0;
    private boolean m_booleanValue;
    private Response.RuntimeResponse m_runtimeBeginResponse;
    private Response.RuntimeResponse m_runtimeDuringResponse;
    private Response.RuntimeResponse m_runtimeEndResponse;
    public boolean listeningToKeypress = false;

    protected boolean invokeEndOnStop() {
        return false;
    }

    @Override
    public void stopAllRuntimeResponses(double time) {
        if (this.m_runtimeBeginResponse != null && this.m_runtimeBeginResponse.isActive()) {
            this.m_runtimeBeginResponse.stop(time);
        }
        if (this.m_runtimeDuringResponse != null && this.m_runtimeDuringResponse.isActive()) {
            this.m_runtimeDuringResponse.stop(time);
        }
        if (this.m_runtimeEndResponse != null) {
            if (this.m_runtimeEndResponse.isActive()) {
                this.m_runtimeEndResponse.stop(time);
            } else if (this.invokeEndOnStop()) {
                this.m_runtimeEndResponse.prologue(time);
                this.m_runtimeEndResponse.update(time);
                this.m_runtimeEndResponse.epilogue(time);
            }
        }
    }

    protected void set(boolean booleanValue) {
        this.m_booleanValue = booleanValue;
    }

    @Override
    protected void internalSchedule(double t, double dt) {
        double timeRemaining = 0.0;
        if (this.m_runtimeState == 0 && this.m_booleanValue) {
            if (this.m_runtimeBeginResponse != null) {
                this.m_runtimeState = 1;
                this.m_runtimeBeginResponse.prologue(t);
            } else {
                this.m_runtimeState = 2;
            }
        }
        if (this.m_runtimeState == 1) {
            this.m_runtimeBeginResponse.update(t);
            timeRemaining = this.m_runtimeBeginResponse.getTimeRemaining(t);
            if (timeRemaining <= 0.0) {
                this.m_runtimeBeginResponse.epilogue(t);
                this.m_runtimeState = 2;
            }
        }
        if (this.m_runtimeState == 2) {
            if (this.m_booleanValue) {
                if (this.m_runtimeDuringResponse != null) {
                    if (!this.m_runtimeDuringResponse.isActive()) {
                        this.m_runtimeDuringResponse.prologue(t + timeRemaining);
                    }
                    this.m_runtimeDuringResponse.update(t);
                    timeRemaining = this.m_runtimeDuringResponse.getTimeRemaining(t);
                    if (timeRemaining <= 0.0) {
                        this.m_runtimeDuringResponse.epilogue(t + timeRemaining);
                        this.m_runtimeDuringResponse.prologue(t + timeRemaining);
                    }
                }
            } else {
                if (this.m_runtimeDuringResponse != null) {
                    this.m_runtimeDuringResponse.epilogue(t);
                }
                if (this.m_runtimeEndResponse != null) {
                    this.m_runtimeState = 3;
                    this.m_runtimeEndResponse.prologue(t + timeRemaining);
                } else {
                    this.m_runtimeState = 0;
                }
            }
        }
        if (this.m_runtimeState == 3) {
            this.m_runtimeEndResponse.update(t);
            timeRemaining = this.m_runtimeEndResponse.getTimeRemaining(t);
            if (timeRemaining <= 0.0) {
                this.m_runtimeEndResponse.epilogue(t);
                this.m_runtimeState = 0;
            }
        }
    }

    @Override
    protected void started(World world, double time) {
        super.started(world, time);
        Response beginResponseValue = this.beginResponse.getResponseValue();
        Response duringResponseValue = this.duringResponse.getResponseValue();
        Response endResponseValue = this.endResponse.getResponseValue();
        if (beginResponseValue != null && beginResponseValue.isCommentedOut.booleanValue()) {
            beginResponseValue = null;
        }
        if (duringResponseValue != null && duringResponseValue.isCommentedOut.booleanValue()) {
            duringResponseValue = null;
        }
        if (endResponseValue != null && endResponseValue.isCommentedOut.booleanValue()) {
            endResponseValue = null;
        }
        this.m_runtimeBeginResponse = beginResponseValue != null ? beginResponseValue.manufactureRuntimeResponse() : null;
        this.m_runtimeDuringResponse = duringResponseValue != null ? duringResponseValue.manufactureRuntimeResponse() : null;
        this.m_runtimeEndResponse = endResponseValue != null ? endResponseValue.manufactureRuntimeResponse() : null;
        this.m_runtimeState = 0;
    }
}

