/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.TriggerBehavior;
import edu.cmu.cs.stage3.alice.core.event.MessageEvent;
import edu.cmu.cs.stage3.alice.core.event.MessageListener;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;

public class MessageReceivedBehavior
extends TriggerBehavior
implements MessageListener {
    public final TransformableProperty fromWho = new TransformableProperty((Element)this, "fromWho", null);
    public final TransformableProperty toWhom = new TransformableProperty((Element)this, "toWhom", null);

    @Override
    public void manufactureDetails() {
        super.manufactureDetails();
        Variable message = new Variable();
        message.name.set("message");
        message.setParent(this);
        message.valueClass.set(String.class);
        this.details.add(message);
        Variable fromWho = new Variable();
        fromWho.name.set("fromWho");
        fromWho.setParent(this);
        fromWho.valueClass.set(Transformable.class);
        this.details.add(fromWho);
        Variable toWhom = new Variable();
        toWhom.name.set("message");
        toWhom.setParent(this);
        toWhom.valueClass.set(Transformable.class);
        this.details.add(toWhom);
    }

    private void updateDetails(MessageEvent messageEvent) {
        int i = 0;
        while (i < this.details.size()) {
            Variable detail = (Variable)this.details.get(i);
            if (detail.name.getStringValue().equals("message")) {
                detail.value.set(messageEvent.getMessage());
            } else if (detail.name.getStringValue().equals("fromWho")) {
                detail.value.set(messageEvent.getFromWho());
            } else if (detail.name.getStringValue().equals("toWhom")) {
                detail.value.set(messageEvent.getToWhom());
            }
            ++i;
        }
    }

    private boolean check(MessageEvent messageEvent) {
        Transformable toWhomValue;
        Transformable fromWhoValue = this.fromWho.getTransformableValue();
        return !(fromWhoValue != null && messageEvent.getFromWho() != fromWhoValue || (toWhomValue = this.toWhom.getTransformableValue()) != null && messageEvent.getToWhom() != toWhomValue);
    }

    @Override
    public void messageSent(MessageEvent messageEvent) {
        if (this.check(messageEvent)) {
            this.updateDetails(messageEvent);
            this.trigger((double)messageEvent.getWhen() * 0.001);
        }
    }

    @Override
    protected void started(World world, double time) {
        super.started(world, time);
        world.addMessageListener(this);
    }

    @Override
    protected void stopped(World world, double time) {
        super.stopped(world, time);
        world.removeMessageListener(this);
    }
}

