/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.InternalResponseBehavior;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.vecmath.Vector3d;

public class MouseLookingBehavior
extends InternalResponseBehavior
implements MouseListener,
MouseMotionListener {
    private RenderTarget renderTarget;
    private Vector3d turning = new Vector3d();
    private boolean mouseActive;
    private int lastX;
    private int lastY;
    public NumberProperty turningRate = new NumberProperty(this, "turningRate", new Double(0.001));
    public TransformableProperty subject = new TransformableProperty((Element)this, "subject", null);
    public BooleanProperty onlyAffectsYaw = new BooleanProperty(this, "onlyAffectsYaw", Boolean.TRUE);

    protected void disable() {
        this.renderTarget.removeMouseListener(this);
        this.renderTarget.removeMouseMotionListener(this);
        this.mouseActive = false;
    }

    protected void enable() {
        this.renderTarget.addMouseListener(this);
        this.renderTarget.addMouseMotionListener(this);
        this.mouseActive = false;
    }

    @Override
    public void started(World world, double time) {
        super.started(world, time);
        if (this.isEnabled.booleanValue()) {
            RenderTarget[] rts = (RenderTarget[])world.getDescendants(RenderTarget.class);
            if (rts.length > 0) {
                Camera[] cameras;
                this.renderTarget = rts[0];
                if (this.subject.get() == null && (cameras = this.renderTarget.getCameras()).length > 0) {
                    this.subject.set(cameras[0]);
                }
            }
            this.enable();
        }
    }

    @Override
    public void stopped(World world, double time) {
        super.stopped(world, time);
        if (this.isEnabled.booleanValue()) {
            this.disable();
        }
    }

    @Override
    public void internalSchedule(double time, double dt) {
        this.subject.getTransformableValue().turnRightNow(Direction.FORWARD, this.turning.x);
        Transformable t = new Transformable();
        t.setPositionRightNow(this.subject.getTransformableValue().getPosition());
        t.setOrientationRightNow(this.subject.getTransformableValue().vehicle.getReferenceFrameValue().getOrientationAsQuaternion());
        this.subject.getTransformableValue().turnRightNow(Direction.RIGHT, this.turning.y, t);
        this.turning.x = 0.0;
        this.turning.y = 0.0;
        this.turning.z = 0.0;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
        this.mouseActive = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseActive = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX() - this.lastX;
        int y = e.getY() - this.lastY;
        if (this.lastX == -1) {
            x = 0;
        }
        if (this.lastY == -1) {
            y = 0;
        }
        this.lastX = e.getX();
        this.lastY = e.getY();
        if (this.mouseActive) {
            if (((Boolean)this.onlyAffectsYaw.get()).booleanValue()) {
                this.turning.y += (double)x * this.turningRate.getNumberValue().doubleValue();
            } else {
                this.turning.y += (double)x * this.turningRate.getNumberValue().doubleValue();
                this.turning.x += (double)y * this.turningRate.getNumberValue().doubleValue();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

