/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.bubble;

import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.bubble.SubText;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.vecmath.Vector3d;

public abstract class Bubble {
    private String m_text = null;
    private Color m_backgroundColor = Color.white;
    private Color m_foregroundColor = Color.black;
    private Font m_font = null;
    private boolean m_isShowing = true;
    private ReferenceFrame m_referenceFrame = null;
    private Vector3d m_offsetFromReferenceFrame = new Vector3d();
    protected Vector m_subTexts = new Vector();
    protected Point m_pixelOffset = null;
    private Point m_origin = new Point();
    private int m_charsPerLine = 32;
    protected static final int PAD_X = 10;
    protected static final int PAD_Y = 10;

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
        this.m_subTexts.clear();
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.m_backgroundColor = backgroundColor;
    }

    public Color getForegroundColor() {
        return this.m_foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.m_foregroundColor = foregroundColor;
    }

    public Font getFont() {
        return this.m_font;
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    public void setCharactersPerLine(int charsPerLine) {
        this.m_charsPerLine = charsPerLine;
    }

    public boolean isShowing() {
        return this.m_isShowing;
    }

    public void setIsShowing(boolean isShowing) {
        this.m_isShowing = isShowing;
    }

    public void show() {
        this.setIsShowing(true);
    }

    public void hide() {
        this.setIsShowing(false);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.m_referenceFrame;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.m_referenceFrame = referenceFrame;
    }

    public Vector3d getOffsetFromReferenceFrame() {
        return this.m_offsetFromReferenceFrame;
    }

    public void setOffsetFromReferenceFrame(Vector3d offsetFromReferenceFrame) {
        this.m_offsetFromReferenceFrame = offsetFromReferenceFrame;
    }

    public Point getPixelOffset() {
        return this.m_pixelOffset;
    }

    public void setPixelOffset(Point pixelOffset) {
        this.m_pixelOffset = pixelOffset;
    }

    protected Point getOrigin() {
        return this.m_origin;
    }

    public Rectangle2D getTotalBound() {
        if (this.m_subTexts.size() > 0) {
            SubText subText0 = (SubText)this.m_subTexts.elementAt(0);
            Rectangle2D totalBound = subText0.getSafeBound();
            int i = 1;
            while (i < this.m_subTexts.size()) {
                SubText subTextI = (SubText)this.m_subTexts.elementAt(i);
                Rectangle2D.union(totalBound, subTextI.getBound(), totalBound);
                ++i;
            }
            return totalBound;
        }
        return null;
    }

    public void calculateBounds(RenderTarget rt) {
        Rectangle2D totalBound = this.getTotalBound();
        if (totalBound == null && this.m_text != null && this.m_font != null) {
            int n = this.m_charsPerLine;
            this.m_subTexts.clear();
            FontRenderContext frc = new FontRenderContext(null, false, false);
            int offsetY = 0;
            int i = 0;
            while (i < this.m_text.length()) {
                int limit;
                if (i + n > this.m_text.length()) {
                    limit = this.m_text.length();
                } else {
                    limit = this.m_text.indexOf(32, i + n);
                    if (limit == -1) {
                        limit = this.m_text.length();
                    }
                }
                String substring = this.m_text.substring(i, limit);
                Rectangle2D boundI = this.m_font.getStringBounds(substring, frc);
                this.m_subTexts.addElement(new SubText(substring, boundI, offsetY));
                offsetY = (int)((double)offsetY + boundI.getHeight());
                i = limit + 1;
            }
        }
    }

    public void calculateOrigin(RenderTarget rt) {
        edu.cmu.cs.stage3.alice.scenegraph.Camera sgCamera;
        Camera camera;
        edu.cmu.cs.stage3.alice.scenegraph.Camera[] sgCameras;
        this.m_origin.x = 300;
        this.m_origin.y = 300;
        if (this.m_referenceFrame != null && (sgCameras = rt.getCameras()).length > 0 && (camera = (Camera)(sgCamera = sgCameras[0]).getBonus()) != null && camera != this.m_referenceFrame) {
            Vector3d xyzInCamera = this.m_referenceFrame.transformTo(this.m_offsetFromReferenceFrame, (ReferenceFrame)camera);
            Vector3d xyzInViewport = rt.transformFromCameraToViewport(xyzInCamera, sgCamera);
            this.m_origin.x = (int)xyzInViewport.x;
            this.m_origin.y = (int)xyzInViewport.y;
        }
    }

    protected abstract void paintBackground(Graphics var1);

    protected void paint(Graphics g) {
        if (this.m_isShowing) {
            this.paintBackground(g);
            if (this.m_text != null) {
                if (this.m_font != null) {
                    g.setFont(this.m_font);
                }
                g.setColor(this.m_foregroundColor);
                if (this.m_subTexts.size() > 0) {
                    SubText subText0 = (SubText)this.m_subTexts.elementAt(0);
                    int offsetX = this.m_pixelOffset.x;
                    int offsetY = this.m_pixelOffset.y - (int)subText0.getBound().getY();
                    int i = 0;
                    while (i < this.m_subTexts.size()) {
                        SubText subTextI = (SubText)this.m_subTexts.elementAt(i);
                        Rectangle2D boundI = subTextI.getBound();
                        int x = (int)((double)offsetX + boundI.getX());
                        int y = (int)((double)offsetY + boundI.getY());
                        g.drawString(subTextI.getText(), x, y);
                        ++i;
                    }
                }
            }
        }
    }
}

