/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.bubble;

import edu.cmu.cs.stage3.alice.core.bubble.Bubble;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;

public class NarrateBubble
extends Bubble {
    private boolean m_displayTopOfScreen = false;
    private Rectangle actualViewport = null;

    public NarrateBubble() {
        this.setCharactersPerLine(60);
    }

    @Override
    public void calculateOrigin(RenderTarget rt) {
    }

    @Override
    public void calculateBounds(RenderTarget rt) {
        Camera[] sgCameras = rt.getCameras();
        if (sgCameras.length > 0) {
            Camera sgCamera = sgCameras[0];
            this.actualViewport = rt.getActualViewport(sgCamera);
            Font font = this.getFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            double charCnt = this.actualViewport.getWidth() / (double)fontMetrics.charWidth('W');
            this.setCharactersPerLine((int)charCnt * 2);
        }
        super.calculateBounds(rt);
        Rectangle2D totalBound = this.getTotalBound();
        if (sgCameras.length > 0) {
            Camera sgCamera = sgCameras[0];
            this.actualViewport = rt.getActualViewport(sgCamera);
            double x = this.actualViewport.getX() + this.actualViewport.getWidth() / 2.0 - totalBound.getWidth() / 2.0;
            double y = 0.0;
            if (this.m_displayTopOfScreen) {
                y = 10.0;
                if (totalBound.getY() < 0.0) {
                    y = -1.0 * totalBound.getY() + 10.0;
                }
            } else {
                y = (double)this.actualViewport.y + this.actualViewport.getHeight() - totalBound.getHeight() + 10.0;
            }
            this.setPixelOffset(new Point((int)x, (int)y));
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
        Rectangle2D totalBound = this.getTotalBound();
        Point origin = this.getOrigin();
        Point pixelOffset = this.getPixelOffset();
        int x = this.actualViewport.x;
        int y = (int)(totalBound.getY() + (double)pixelOffset.y - 10.0);
        int width = this.actualViewport.width;
        int height = (int)totalBound.getHeight() + 10 + 10;
        g.setColor(this.getBackgroundColor());
        g.fillRoundRect(x, y, width, height, 5, 5);
        g.setColor(Color.black);
        g.drawRoundRect(x, y, width, height, 5, 5);
    }
}

