/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.camera;

import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.decorator.SymmetricPerspectiveViewVolumeDecorator;
import edu.cmu.cs.stage3.alice.core.decorator.ViewVolumeDecorator;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;

public class SymmetricPerspectiveCamera
extends Camera {
    public final NumberProperty verticalViewingAngle = new NumberProperty(this, "verticalViewingAngle", null);
    public final NumberProperty horizontalViewingAngle = new NumberProperty(this, "horizontalViewingAngle", null);

    public SymmetricPerspectiveCamera() {
        super(new edu.cmu.cs.stage3.alice.scenegraph.SymmetricPerspectiveCamera());
    }

    public edu.cmu.cs.stage3.alice.scenegraph.SymmetricPerspectiveCamera getSceneGraphSymmetricPerspectiveCamera() {
        return (edu.cmu.cs.stage3.alice.scenegraph.SymmetricPerspectiveCamera)this.getSceneGraphCamera();
    }

    @Override
    protected ViewVolumeDecorator createViewVolumeDecorator() {
        SymmetricPerspectiveViewVolumeDecorator symmetricPerspectiveViewVolumeDecorator = new SymmetricPerspectiveViewVolumeDecorator();
        symmetricPerspectiveViewVolumeDecorator.setSymmetricPerspectiveCamera(this);
        return symmetricPerspectiveViewVolumeDecorator;
    }

    protected void verticalViewingAngleValueChanged(Number value) {
        double d = Double.NaN;
        if (value != null) {
            d = value.doubleValue();
        }
        this.getSceneGraphSymmetricPerspectiveCamera().setVerticalViewingAngle(d);
    }

    protected void horizontalViewingAngleValueChanged(Number value) {
        double d = Double.NaN;
        if (value != null) {
            d = value.doubleValue();
        }
        this.getSceneGraphSymmetricPerspectiveCamera().setHorizontalViewingAngle(d);
    }

    @Override
    protected void propertyChanged(Property property, Object value) {
        if (property == this.verticalViewingAngle) {
            this.verticalViewingAngleValueChanged((Number)value);
        } else if (property == this.horizontalViewingAngle) {
            this.horizontalViewingAngleValueChanged((Number)value);
        } else {
            super.propertyChanged(property, value);
        }
    }

    @Override
    protected double getViewingAngleForGetAGoodLookAt() {
        double vva = this.verticalViewingAngle.doubleValue();
        double hva = this.horizontalViewingAngle.doubleValue();
        if (Double.isNaN(vva)) {
            if (Double.isNaN(hva)) {
                return super.getViewingAngleForGetAGoodLookAt();
            }
            return vva;
        }
        if (Double.isNaN(hva)) {
            return vva;
        }
        return Math.min(vva, hva);
    }
}

