/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.clock;

import edu.cmu.cs.stage3.alice.core.Clock;
import edu.cmu.cs.stage3.alice.core.World;

public class FixedFrameRateClock
implements Clock {
    private World m_world;
    private int m_frameRate;
    private double m_dt;
    private double m_time;

    public FixedFrameRateClock() {
        this(24);
    }

    public FixedFrameRateClock(int frameRate) {
        this.setFrameRate(frameRate);
    }

    @Override
    public World getWorld() {
        return this.m_world;
    }

    @Override
    public void setWorld(World world) {
        this.m_world = world;
    }

    public int getFrameRate() {
        return this.m_frameRate;
    }

    public void setFrameRate(int frameRate) {
        this.m_frameRate = frameRate;
        this.m_dt = 1.0 / (double)this.m_frameRate;
    }

    @Override
    public void start() {
        this.m_time = -this.m_dt;
        if (this.m_world != null) {
            this.m_world.start();
        }
    }

    @Override
    public void stop() {
        if (this.m_world != null) {
            this.m_world.stop();
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public double getTime() {
        return this.m_time;
    }

    @Override
    public double getTimeElapsed() {
        return this.getTime();
    }

    @Override
    public void schedule() {
        if (this.m_world != null) {
            this.m_time += this.m_dt;
            this.m_world.schedule();
        }
    }
}

