/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.criterion;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.util.Criterion;
import java.lang.reflect.Constructor;

public class ElementKeyedCriterion
implements Criterion {
    private String m_key;
    private boolean m_ignoreCase;

    public ElementKeyedCriterion(String key) {
        this(key, true);
    }

    public ElementKeyedCriterion(String key, boolean ignoreCase) {
        this.m_key = key;
        this.m_ignoreCase = ignoreCase;
    }

    public String getKey() {
        return this.m_key;
    }

    public boolean getIgnoreCase() {
        return this.m_ignoreCase;
    }

    @Override
    public boolean accept(Object o) {
        if (o instanceof Element) {
            String key = ((Element)o).getKey();
            if (this.m_key == null) {
                return key == null;
            }
            if (this.m_ignoreCase) {
                return this.m_key.equalsIgnoreCase(key);
            }
            return this.m_key.equals(key);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.m_key + "]";
    }

    protected static ElementKeyedCriterion valueOf(String s, Class cls) {
        String beginMarker = String.valueOf(cls.getName()) + "[";
        String endMarker = "]";
        int begin = s.indexOf(beginMarker) + beginMarker.length();
        int end = s.lastIndexOf(endMarker);
        try {
            Class[] types = new Class[]{String.class};
            Object[] values = new Object[]{s.substring(begin, end)};
            Constructor constructor = cls.getConstructor(types);
            return (ElementKeyedCriterion)constructor.newInstance(values);
        }
        catch (Throwable t) {
            throw new RuntimeException();
        }
    }

    public static ElementKeyedCriterion valueOf(String s) {
        return ElementKeyedCriterion.valueOf(s, ElementKeyedCriterion.class);
    }
}

