/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.decorator;

import edu.cmu.cs.stage3.alice.core.Decorator;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.LineStrip;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.math.Sphere;
import javax.vecmath.Point3d;

public class BoundingSphereDecorator
extends Decorator {
    private static final int RESOLUTION_THETA = 25;
    private static double[] sines = new double[25];
    private static double[] cosines = new double[25];
    private LineStrip m_sgLineStrip = null;
    private ReferenceFrame m_referenceFrame = null;

    static {
        double dtheta = 0.25132741228718347;
        double theta = 0.0;
        int i = 0;
        while (i < 25) {
            BoundingSphereDecorator.sines[i] = Math.sin(theta);
            BoundingSphereDecorator.cosines[i] = Math.cos(theta);
            theta += dtheta;
            ++i;
        }
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.m_referenceFrame;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        if (referenceFrame != this.m_referenceFrame) {
            this.m_referenceFrame = referenceFrame;
            this.markDirty();
            this.updateIfShowing();
        }
    }

    @Override
    public void internalRelease(int pass) {
        switch (pass) {
            case 2: {
                if (this.m_sgLineStrip == null) break;
                this.m_sgLineStrip.release();
                this.m_sgLineStrip = null;
            }
        }
        super.internalRelease(pass);
    }

    @Override
    protected void update() {
        super.update();
        Sphere sphere = this.m_referenceFrame.getBoundingSphere();
        if (sphere == null || sphere.getCenter() == null || Double.isNaN(sphere.getRadius())) {
            return;
        }
        boolean requiresVerticesToBeUpdated = this.isDirty();
        if (this.m_sgLineStrip == null) {
            this.m_sgLineStrip = new LineStrip();
            this.m_sgVisual.setGeometry(this.m_sgLineStrip);
            this.m_sgLineStrip.setBonus(this.getReferenceFrame());
            requiresVerticesToBeUpdated = true;
        }
        if (requiresVerticesToBeUpdated) {
            double r = sphere.getRadius();
            double x = sphere.getCenter().x;
            double y = sphere.getCenter().y;
            double z = sphere.getCenter().z;
            Color xColor = Color.RED;
            Color yColor = Color.GREEN;
            Color zColor = Color.BLUE;
            Vertex3d[] xVertices = new Vertex3d[26];
            Vertex3d[] yVertices = new Vertex3d[26];
            Vertex3d[] zVertices = new Vertex3d[26];
            int i = 0;
            while (i < 25) {
                xVertices[i] = new Vertex3d(new Point3d(x, y + cosines[i] * r, z + sines[i] * r), null, xColor, null, null);
                yVertices[i] = new Vertex3d(new Point3d(x + cosines[i] * r, y, z + sines[i] * r), null, yColor, null, null);
                zVertices[i] = new Vertex3d(new Point3d(x + cosines[i] * r, y + sines[i] * r, z), null, zColor, null, null);
                ++i;
            }
            xVertices[25] = xVertices[0];
            yVertices[25] = yVertices[0];
            zVertices[25] = zVertices[0];
            Vertex3d[] vertices = new Vertex3d[xVertices.length + yVertices.length + zVertices.length];
            System.arraycopy(xVertices, 0, vertices, 0, xVertices.length);
            System.arraycopy(yVertices, 0, vertices, xVertices.length, yVertices.length);
            System.arraycopy(zVertices, 0, vertices, xVertices.length + yVertices.length, zVertices.length);
            this.m_sgLineStrip.setVertices(vertices);
        }
        this.setIsDirty(false);
    }
}

