/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.decorator;

import edu.cmu.cs.stage3.alice.core.Decorator;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.LineArray;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class BoxDecorator
extends Decorator {
    private ReferenceFrame m_referenceFrame;
    private LineArray m_sgLineArray = null;
    private double m_width;
    private double m_height;
    private double m_depth;

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.m_referenceFrame;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.m_referenceFrame = referenceFrame;
    }

    public double getWidth() {
        return this.m_width;
    }

    public void setWidth(double width) {
        this.m_width = width;
        this.markDirty();
    }

    public double getHeight() {
        return this.m_height;
    }

    public void setHeight(double height) {
        this.m_height = height;
        this.markDirty();
    }

    public double getDepth() {
        return this.m_depth;
    }

    public void setDepth(double depth) {
        this.m_depth = depth;
        this.markDirty();
    }

    @Override
    public void internalRelease(int pass) {
        switch (pass) {
            case 2: {
                if (this.m_sgLineArray == null) break;
                this.m_sgLineArray.release();
                this.m_sgLineArray = null;
            }
        }
        super.internalRelease(pass);
    }

    @Override
    protected void update() {
        super.update();
        boolean requiresVerticesToBeUpdated = this.isDirty();
        if (this.m_sgLineArray == null) {
            this.m_sgLineArray = new LineArray();
            this.m_sgVisual.setGeometry(this.m_sgLineArray);
            this.m_sgLineArray.setBonus(this.getReferenceFrame());
            requiresVerticesToBeUpdated = true;
        }
        if (requiresVerticesToBeUpdated) {
            Color color = Color.YELLOW;
            Vertex3d[] vertices = new Vertex3d[24];
            Vector3d min = new Vector3d(-this.m_width / 2.0, 0.0, -this.m_depth / 2.0);
            Vector3d max = new Vector3d(this.m_width / 2.0, this.m_height, this.m_depth / 2.0);
            Vertex3d[] vs = new Vertex3d[]{new Vertex3d(new Point3d(min.x, min.y, min.z), null, color, null, null), new Vertex3d(new Point3d(min.x, min.y, max.z), null, color, null, null), new Vertex3d(new Point3d(max.x, min.y, max.z), null, color, null, null), new Vertex3d(new Point3d(max.x, min.y, min.z), null, color, null, null), new Vertex3d(new Point3d(min.x, max.y, min.z), null, color, null, null), new Vertex3d(new Point3d(min.x, max.y, max.z), null, color, null, null), new Vertex3d(new Point3d(max.x, max.y, max.z), null, color, null, null), new Vertex3d(new Point3d(max.x, max.y, min.z), null, color, null, null)};
            int bottom = 0;
            int top = 8;
            int sides = 16;
            int lcv = 0;
            while (lcv < 4) {
                vertices[bottom++] = vs[lcv];
                vertices[bottom++] = vs[(lcv + 1) % 4];
                vertices[top++] = vs[4 + lcv];
                vertices[top++] = vs[4 + (lcv + 1) % 4];
                vertices[sides++] = vs[lcv];
                vertices[sides++] = vs[lcv + 4];
                ++lcv;
            }
            this.m_sgLineArray.setVertices(vertices);
        }
        this.setIsDirty(false);
    }
}

