/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.geometry;

import edu.cmu.cs.stage3.alice.core.geometry.Polygon;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import java.awt.geom.PathIterator;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple3d;

public class PolygonGroup {
    private Polygon[] polygons = null;
    private Vertex3d[] vertices = null;
    private int[] indices = null;

    protected void addPolygon(Polygon poly) {
        if (this.polygons == null) {
            this.polygons = new Polygon[1];
        } else {
            Polygon[] temp = new Polygon[this.polygons.length + 1];
            System.arraycopy(this.polygons, 0, temp, 0, this.polygons.length);
            this.polygons = temp;
        }
        this.polygons[this.polygons.length - 1] = poly;
    }

    public void parsePathIterator(PathIterator pi, Point2d offset, int curvature) {
        double[] coords = new double[6];
        int type = -1;
        boolean advance = true;
        while (!pi.isDone()) {
            type = pi.currentSegment(coords);
            switch (type) {
                case 0: {
                    Polygon p = new Polygon();
                    advance = p.parsePathIterator(pi, offset, curvature);
                    if (p.isNull()) break;
                    this.addPolygon(p);
                }
            }
            if (!advance || pi.isDone()) continue;
            pi.next();
        }
    }

    public void triangulate(double extz) {
        this.vertices = null;
        this.indices = null;
        if (this.polygons == null) {
            return;
        }
        int i = 0;
        while (i < this.polygons.length) {
            this.polygons[i].triangulate(extz);
            ++i;
        }
        this.vertices = new Vertex3d[this.polygons[0].getVertices().length];
        this.indices = new int[this.polygons[0].getIndices().length];
        System.arraycopy(this.polygons[0].getVertices(), 0, this.vertices, 0, this.vertices.length);
        System.arraycopy(this.polygons[0].getIndices(), 0, this.indices, 0, this.indices.length);
        if (this.vertices == null || this.indices == null) {
            return;
        }
        i = 0;
        while (i < this.polygons.length) {
            Vertex3d[] newVertices = new Vertex3d[this.vertices.length + this.polygons[i].getVertices().length];
            System.arraycopy(this.vertices, 0, newVertices, 0, this.vertices.length);
            int offset = this.vertices.length;
            System.arraycopy(this.polygons[i].getVertices(), 0, newVertices, this.vertices.length, this.polygons[i].getVertices().length);
            this.vertices = newVertices;
            int[] newIndices = new int[this.indices.length + this.polygons[i].getIndices().length];
            System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
            int j = 0;
            while (j < this.polygons[i].getIndices().length) {
                newIndices[this.indices.length + j] = this.polygons[i].getIndices()[j] + offset;
                ++j;
            }
            this.indices = newIndices;
            ++i;
        }
    }

    protected void shareVertices() {
        if (this.vertices == null || this.indices == null) {
            return;
        }
        int i = 0;
        while (i < this.vertices.length) {
            int j = i + 1;
            while (j < this.vertices.length) {
                if (this.vertices[i].position.equals((Tuple3d)this.vertices[j].position) && this.vertices[i].normal.equals((Tuple3d)this.vertices[j].normal)) {
                    int k = j + 1;
                    while (k < this.vertices.length) {
                        this.vertices[k - 1] = this.vertices[k];
                        ++k;
                    }
                    Vertex3d[] newVertices = new Vertex3d[this.vertices.length - 1];
                    System.arraycopy(this.vertices, 0, newVertices, 0, newVertices.length);
                    this.vertices = newVertices;
                    int k2 = 0;
                    while (k2 < this.indices.length) {
                        if (this.indices[k2] == j) {
                            this.indices[k2] = i;
                        } else if (this.indices[k2] > j) {
                            int n = k2;
                            this.indices[n] = this.indices[n] - 1;
                        }
                        ++k2;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public Vertex3d[] getVertices() {
        return this.vertices;
    }

    public int[] getIndices() {
        return this.indices;
    }
}

