/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.geometry;

import edu.cmu.cs.stage3.alice.core.Geometry;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.geometry.PolygonGroup;
import edu.cmu.cs.stage3.alice.core.property.FontProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.StringProperty;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;

public class Text3D
extends Geometry {
    public final StringProperty text = new StringProperty(this, "text", null);
    public final FontProperty font = new FontProperty(this, "font", null);
    public final NumberProperty extrusion = new NumberProperty(this, "extrusion", new Double(0.25));
    public final NumberProperty curvature = new NumberProperty(this, "curvature", new Integer(2));
    private Font m_font = null;
    private int m_curvature = 0;

    public Text3D() {
        super(new IndexedTriangleArray());
        this.updateGeometry();
    }

    @Override
    protected void propertyChanged(Property property, Object value) {
        if (property == this.text) {
            this.updateGeometry();
        } else if (property == this.font || property == this.curvature) {
            if (this.m_curvature != this.curvature.intValue() || !this.m_font.equals(this.font.getFontValue())) {
                this.updateGeometry();
            }
        } else if (property == this.extrusion) {
            this.updateExtrusion();
        } else {
            super.propertyChanged(property, value);
        }
    }

    protected void updateExtrusion() {
        double extz = this.extrusion.doubleValue() / 2.0;
        Vertex3d[] verts = ((IndexedTriangleArray)this.getSceneGraphGeometry()).getVertices();
        if (verts != null) {
            int i = 0;
            while (i < verts.length) {
                verts[i].position.z = extz * (double)(verts[i].position.z > 0.0 ? 1 : -1);
                ++i;
            }
            ((IndexedTriangleArray)this.getSceneGraphGeometry()).setVertices(verts);
        }
    }

    protected void updateGeometry() {
        Point2d offset;
        int i;
        GlyphVector gv;
        if (this.font.getFontValue() == null || this.text.getStringValue() == null || this.extrusion.getNumberValue() == null || this.curvature.getNumberValue() == null) {
            return;
        }
        this.m_font = this.font.getFontValue();
        this.m_curvature = this.curvature.intValue();
        PolygonGroup pg = new PolygonGroup();
        Point2d shiftOffset = new Point2d(0.0, 0.0);
        int loc = 0;
        int lineCount = 1;
        String m_text = this.text.getStringValue();
        while (m_text.indexOf(10, loc) != -1) {
            ++lineCount;
            gv = this.m_font.createGlyphVector(new FontRenderContext(new AffineTransform(), false, true), m_text.substring(loc, m_text.indexOf(10, loc)));
            shiftOffset.x = gv.getVisualBounds().getWidth() / 2.0;
            i = 0;
            while (i < gv.getNumGlyphs()) {
                offset = new Point2d(-gv.getGlyphPosition(i).getX() + shiftOffset.x, -gv.getGlyphPosition(i).getY() + shiftOffset.y);
                this.buildGlyph(pg, gv.getGlyphOutline(i), offset, this.curvature.intValue());
                ++i;
            }
            shiftOffset.y -= gv.getVisualBounds().getHeight();
            loc = m_text.indexOf(10, loc) + 1;
        }
        if (loc < m_text.length()) {
            gv = this.m_font.createGlyphVector(new FontRenderContext(new AffineTransform(), false, true), m_text.substring(loc));
            shiftOffset.x = gv.getVisualBounds().getWidth() / 2.0;
            i = 0;
            while (i < gv.getNumGlyphs()) {
                offset = new Point2d(-gv.getGlyphPosition(i).getX() / 10.0 + shiftOffset.x, -gv.getGlyphPosition(i).getY() + shiftOffset.y);
                this.buildGlyph(pg, gv.getGlyphOutline(i), offset, this.curvature.intValue());
                ++i;
            }
        }
        pg.triangulate(this.extrusion.doubleValue());
        ((IndexedTriangleArray)this.getSceneGraphGeometry()).setVertices(pg.getVertices());
        ((IndexedTriangleArray)this.getSceneGraphGeometry()).setIndices(pg.getIndices());
        if (pg.getVertices() != null) {
            Vertex3d[] verts = new Vertex3d[pg.getVertices().length];
            double height = this.getSceneGraphGeometry().getBoundingBox().getHeight() / (double)lineCount;
            int i2 = 0;
            while (i2 < verts.length) {
                verts[i2] = new Vertex3d((Point3d)pg.getVertices()[i2].position.clone(), pg.getVertices()[i2].normal, null, null, new TexCoord2f());
                verts[i2].scale(1.0 / height, 1.0 / height, 1.0);
                ++i2;
            }
            ((IndexedTriangleArray)this.getSceneGraphGeometry()).setVertices(verts);
        }
    }

    protected void buildGlyph(PolygonGroup pg, Shape outline, Point2d offset, int curvature) {
        PathIterator pi = outline.getPathIterator(new AffineTransform());
        pg.parsePathIterator(pi, offset, curvature);
    }
}

