/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.manipulator;

import edu.cmu.cs.stage3.alice.core.manipulator.RenderTargetPickManipulator;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix44;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class RenderTargetModelManipulator
extends RenderTargetPickManipulator {
    public static final int GROUND_PLANE_MODE = 1;
    public static final int CAMERA_PLANE_MODE = 2;
    public static final int DEFAULT_MODE = 1;
    protected Transformable helper = new Transformable();
    protected Camera sgCamera = null;
    protected Transformable sgCameraTransformable = null;
    protected Scene sgScene = null;
    protected Transformable sgIdentity = new Transformable();
    protected Vector3d tempVec = new Vector3d();
    protected Vector3d zeroVec = new Vector3d(0.0, 0.0, 0.0);
    protected Vector4d tempVec4 = new Vector4d();
    protected Vector3d cameraForward = new Vector3d();
    protected Vector3d cameraUp = new Vector3d();
    protected Matrix44 oldTransformation;
    protected int mode = 1;
    protected boolean popupEnabled = false;

    public RenderTargetModelManipulator(OnscreenRenderTarget renderTarget) {
        super(renderTarget);
        this.setMode(1);
        this.helper.setName("helper");
    }

    public void setMode(int mode) {
        this.mode = mode;
        if (mode == 1) {
            this.setHideCursorOnDrag(true);
        } else if (mode == 2) {
            this.setHideCursorOnDrag(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (this.enabled) {
            super.mousePressed(ev);
            if (this.ePickedTransformable != null && !this.ePickedTransformable.doEventsStopAscending()) {
                this.abortAction();
            } else if (this.sgPickedTransformable != null) {
                this.sgCamera = this.renderTarget.getCameras()[0];
                this.sgCameraTransformable = (Transformable)this.sgCamera.getParent();
                this.sgScene = (Scene)this.sgCamera.getRoot();
                this.oldTransformation = new Matrix44(this.sgPickedTransformable.getLocalTransformation());
                this.helper.setParent(this.sgScene);
                this.sgIdentity.setParent(this.sgScene);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        if (this.enabled) {
            super.mouseDragged(ev);
            if (this.mouseIsDown && this.sgPickedTransformable != null) {
                double deltaFactor = 0.0;
                if (this.renderTarget != null) {
                    if (this.sgCamera instanceof OrthographicCamera) {
                        OrthographicCamera orthoCamera = (OrthographicCamera)this.sgCamera;
                        double nearClipHeightInScreen = this.renderTarget.getAWTComponent().getHeight();
                        double nearClipHeightInWorld = orthoCamera.getPlane()[3] - orthoCamera.getPlane()[1];
                        deltaFactor = nearClipHeightInWorld / nearClipHeightInScreen;
                    } else {
                        double projectionMatrix11 = this.renderTarget.getProjectionMatrix(this.sgCamera).getElement(1, 1);
                        double nearClipDist = this.sgCamera.getNearClippingPlaneDistance();
                        double nearClipHeightInWorld = 2.0 * (nearClipDist / projectionMatrix11);
                        double nearClipHeightInScreen = this.renderTarget.getAWTComponent().getHeight();
                        double pixelHeight = nearClipHeightInWorld / nearClipHeightInScreen;
                        double objectDist = this.sgPickedTransformable.getPosition(this.sgCameraTransformable).getLength();
                        deltaFactor = objectDist * pixelHeight / nearClipDist;
                    }
                }
                boolean controlDown = ev.isControlDown();
                boolean shiftDown = ev.isShiftDown();
                if (this.mode == 1) {
                    if (controlDown) {
                        if (shiftDown) {
                            this.helper.setTransformation(MathUtilities.createIdentityMatrix4d(), this.sgCameraTransformable);
                            this.helper.setPosition(this.zeroVec, this.sgPickedTransformable);
                            this.sgPickedTransformable.rotate(MathUtilities.getXAxis(), (double)(-this.dy) * 0.01, this.helper);
                            this.sgPickedTransformable.rotate(MathUtilities.getYAxis(), (double)(-this.dx) * 0.01, this.sgPickedTransformable);
                        } else {
                            this.helper.setTransformation(MathUtilities.createIdentityMatrix4d(), this.sgScene);
                            this.helper.setPosition(this.zeroVec, this.sgPickedTransformable);
                            this.sgPickedTransformable.rotate(MathUtilities.getYAxis(), (double)(-this.dx) * 0.01, this.helper);
                        }
                    } else if (shiftDown) {
                        this.helper.setTransformation(MathUtilities.createIdentityMatrix4d(), this.sgScene);
                        this.helper.setPosition(this.zeroVec, this.sgPickedTransformable);
                        this.tempVec.x = 0.0;
                        this.tempVec.y = (double)(-this.dy) * deltaFactor;
                        this.tempVec.z = 0.0;
                        this.sgPickedTransformable.translate(this.tempVec, this.helper);
                    } else {
                        Matrix4d cameraTransformation = this.sgCameraTransformable.getAbsoluteTransformation();
                        this.cameraUp.x = cameraTransformation.m10;
                        this.cameraUp.y = cameraTransformation.m11;
                        this.cameraUp.z = cameraTransformation.m12;
                        this.cameraForward.x = cameraTransformation.m20;
                        this.cameraForward.y = cameraTransformation.m21;
                        this.cameraForward.z = cameraTransformation.m22;
                        this.helper.setPosition(this.zeroVec, this.sgPickedTransformable);
                        if (Math.abs(this.cameraForward.y) < Math.abs(this.cameraUp.y)) {
                            this.cameraForward.y = 0.0;
                            this.helper.setOrientation(this.cameraForward, this.cameraUp, this.sgScene);
                        } else {
                            this.cameraUp.y = 0.0;
                            this.cameraForward.negate();
                            this.helper.setOrientation(this.cameraUp, this.cameraForward, this.sgScene);
                        }
                        this.tempVec.x = (double)this.dx * deltaFactor;
                        this.tempVec.y = 0.0;
                        this.tempVec.z = (double)(-this.dy) * deltaFactor;
                        this.sgPickedTransformable.translate(this.tempVec, this.helper);
                    }
                } else if (this.mode == 2) {
                    if (controlDown) {
                        if (!shiftDown) {
                            this.helper.setTransformation(MathUtilities.createIdentityMatrix4d(), this.sgCameraTransformable);
                            this.helper.setPosition(this.zeroVec, this.sgPickedTransformable);
                            this.sgPickedTransformable.rotate(MathUtilities.getZAxis(), (double)(-this.dx) * 0.01, this.helper);
                        }
                    } else if (shiftDown) {
                        Point p = ev.getPoint();
                        int bigdx = p.x - this.originalMousePoint.x;
                        int bigdy = p.y - this.originalMousePoint.y;
                        this.sgPickedTransformable.setLocalTransformation(this.oldTransformation);
                        if (Math.abs(bigdx) > Math.abs(bigdy)) {
                            this.tempVec.x = (double)bigdx * deltaFactor;
                            this.tempVec.y = 0.0;
                        } else {
                            this.tempVec.x = 0.0;
                            this.tempVec.y = (double)(-bigdy) * deltaFactor;
                        }
                        this.tempVec.z = 0.0;
                        this.sgPickedTransformable.translate(this.tempVec, this.sgCameraTransformable);
                    } else {
                        this.tempVec.x = (double)this.dx * deltaFactor;
                        this.tempVec.y = (double)(-this.dy) * deltaFactor;
                        this.tempVec.z = 0.0;
                        this.sgPickedTransformable.translate(this.tempVec, this.sgCameraTransformable);
                    }
                }
                if (this.ePickedTransformable != null) {
                    this.ePickedTransformable.localTransformation.set(this.sgPickedTransformable.getLocalTransformation());
                }
            }
        }
    }
}

