/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.manipulator;

import edu.cmu.cs.stage3.awt.AWTUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

public class ScreenWrappingMouseListener
implements MouseListener,
MouseMotionListener {
    protected int pressedx = 0;
    protected int pressedy = 0;
    protected int lastx = 0;
    protected int lasty = 0;
    protected int offsetx = 0;
    protected int offsety = 0;
    protected int dx = 0;
    protected int dy = 0;
    protected boolean mouseIsDown = false;
    private int leftEdge;
    private int rightEdge;
    private int topEdge;
    private int bottomEdge;
    protected boolean doWrap = false;
    private Point tempPoint = new Point();
    private boolean actionAborted = false;
    protected Component component;

    public synchronized boolean isMouseDown() {
        return this.mouseIsDown;
    }

    public synchronized int getPressedX() {
        return this.pressedx;
    }

    public synchronized int getPressedY() {
        return this.pressedy;
    }

    public synchronized int getOffsetX() {
        return this.offsetx;
    }

    public synchronized int getOffsetY() {
        return this.offsety;
    }

    public synchronized int getDX() {
        return this.dx;
    }

    public synchronized int getDY() {
        return this.dy;
    }

    public boolean isActionAborted() {
        return this.actionAborted;
    }

    public synchronized void abortAction() {
        this.actionAborted = true;
        this.mouseIsDown = false;
        this.component.removeMouseMotionListener(this);
    }

    @Override
    public synchronized void mousePressed(MouseEvent ev) {
        this.component = ev.getComponent();
        this.doWrap = AWTUtilities.isSetCursorLocationSupported();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        this.leftEdge = 0;
        this.rightEdge = screenWidth - 1;
        this.topEdge = 0;
        this.bottomEdge = screenHeight - 1;
        this.pressedx = this.lastx = ev.getX();
        this.pressedy = this.lasty = ev.getY();
        this.offsetx = 0;
        this.offsety = 0;
        this.mouseIsDown = true;
        ev.getComponent().addMouseMotionListener(this);
    }

    @Override
    public synchronized void mouseReleased(MouseEvent ev) {
        if (!this.actionAborted) {
            this.mouseIsDown = false;
            ev.getComponent().removeMouseMotionListener(this);
        } else {
            this.actionAborted = false;
        }
    }

    @Override
    public synchronized void mouseDragged(MouseEvent ev) {
        if (this.mouseIsDown) {
            int x = ev.getX();
            int y = ev.getY();
            this.offsetx = x - this.pressedx;
            this.offsety = y - this.pressedy;
            this.dx = x - this.lastx;
            this.dy = y - this.lasty;
            this.lastx = x;
            this.lasty = y;
            if (this.doWrap) {
                this.tempPoint.setLocation(x, y);
                SwingUtilities.convertPointToScreen(this.tempPoint, ev.getComponent());
                if (this.tempPoint.x <= this.leftEdge) {
                    this.tempPoint.x = this.rightEdge - 1 - (this.leftEdge - this.tempPoint.x);
                    this.lastx += this.rightEdge - this.leftEdge;
                    this.pressedx += this.rightEdge - this.leftEdge;
                    AWTUtilities.setCursorLocation(this.tempPoint);
                } else if (this.tempPoint.x >= this.rightEdge) {
                    this.tempPoint.x = this.leftEdge + 1 + (this.tempPoint.x - this.rightEdge);
                    this.lastx -= this.rightEdge - this.leftEdge;
                    this.pressedx -= this.rightEdge - this.leftEdge;
                    AWTUtilities.setCursorLocation(this.tempPoint);
                }
                if (this.tempPoint.y <= this.topEdge) {
                    this.tempPoint.y = this.bottomEdge - 1 - (this.topEdge - this.tempPoint.y);
                    this.lasty += this.bottomEdge - this.topEdge;
                    this.pressedy += this.bottomEdge - this.topEdge;
                    AWTUtilities.setCursorLocation(this.tempPoint);
                } else if (this.tempPoint.y >= this.bottomEdge) {
                    this.tempPoint.y = this.topEdge + 1 + (this.tempPoint.y - this.bottomEdge);
                    this.lasty -= this.bottomEdge - this.topEdge;
                    this.pressedy -= this.bottomEdge - this.topEdge;
                    AWTUtilities.setCursorLocation(this.tempPoint);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
    }
}

