/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.util.HowMuch;
import java.io.IOException;
import java.util.Vector;
import org.w3c.dom.Document;

public class BooleanProperty
extends ObjectProperty {
    public BooleanProperty(Element owner, String name, Boolean defaultValue) {
        super(owner, name, defaultValue, Boolean.class);
    }

    @Override
    public Object getValue() {
        Object value = super.getValue();
        if (value instanceof Number) {
            Number number = (Number)value;
            value = number.byteValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return value;
    }

    public Boolean getBooleanValue() {
        return (Boolean)this.getValue();
    }

    public boolean booleanValue(boolean valueIfNull) {
        Boolean b = this.getBooleanValue();
        if (b != null) {
            return b;
        }
        return valueIfNull;
    }

    public boolean booleanValue() {
        return this.booleanValue(false);
    }

    public void set(boolean value) throws IllegalArgumentException {
        if (value) {
            this.set(Boolean.TRUE);
        } else {
            this.set(Boolean.FALSE);
        }
    }

    public void set(boolean value, HowMuch howMuch) throws IllegalArgumentException {
        if (value) {
            this.set(Boolean.TRUE, howMuch);
        } else {
            this.set(Boolean.FALSE, howMuch);
        }
    }

    @Override
    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        this.set(Boolean.valueOf(this.getNodeText(node)));
    }

    @Override
    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        node.appendChild(this.createNodeForString(document, this.getBooleanValue().toString()));
    }
}

