/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.FileUtilities;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.media.DataSource;
import edu.cmu.cs.stage3.media.Manager;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;

public class DataSourceProperty
extends ObjectProperty {
    public DataSourceProperty(Element owner, String name, DataSource defaultValue) {
        super(owner, name, defaultValue, DataSource.class);
    }

    public DataSource getDataSourceValue() {
        return (DataSource)this.getValue();
    }

    private String getFilename() {
        DataSource dataSourceValue = this.getDataSourceValue();
        return String.valueOf(this.getOwner().name.getStringValue()) + '.' + dataSourceValue.getExtension();
    }

    @Override
    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        this.m_associatedFileKey = null;
        String filename = this.getFilename(this.getNodeText(node));
        InputStream is = loader.readFile(filename);
        this.set(Manager.createDataSource(is, FileUtilities.getExtension(filename)));
        loader.closeCurrentFile();
        try {
            String durationHintText = node.getAttribute("durationHint");
            if (durationHintText != null) {
                double durationHint = Double.parseDouble(durationHintText);
                this.getDataSourceValue().setDurationHint(durationHint);
            }
        }
        catch (Throwable durationHintText) {
            // empty catch block
        }
        try {
            this.m_associatedFileKey = loader.getKeepKey(filename);
        }
        catch (KeepFileNotSupportedException kfnse) {
            this.m_associatedFileKey = null;
        }
    }

    @Override
    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        DataSource dataSourceValue = this.getDataSourceValue();
        if (dataSourceValue != null) {
            Object associatedFileAbsolutePath;
            double duration = dataSourceValue.getDuration(true);
            if (!Double.isNaN(duration)) {
                node.setAttribute("durationHint", Double.toString(duration));
            }
            String filename = this.getFilename();
            try {
                associatedFileAbsolutePath = storer.getKeepKey(filename);
            }
            catch (KeepFileNotSupportedException kfnse) {
                associatedFileAbsolutePath = null;
            }
            if (this.m_associatedFileKey == null || !this.m_associatedFileKey.equals(associatedFileAbsolutePath)) {
                this.m_associatedFileKey = null;
                OutputStream os = storer.createFile(filename, dataSourceValue.isCompressionWorthwhile());
                BufferedOutputStream bos = new BufferedOutputStream(os);
                bos.write(dataSourceValue.getData());
                bos.flush();
                storer.closeCurrentFile();
                this.m_associatedFileKey = associatedFileAbsolutePath;
            } else {
                try {
                    storer.keepFile(filename);
                }
                catch (KeepFileNotSupportedException kfnse) {
                    kfnse.printStackTrace();
                }
                catch (KeepFileDoesNotExistException kfdne) {
                    kfdne.printStackTrace();
                }
            }
            node.appendChild(document.createTextNode("java.io.File[" + filename + "]"));
        }
    }

    @Override
    public void keepAnyAssociatedFiles(DirectoryTreeStorer storer) throws KeepFileNotSupportedException, KeepFileDoesNotExistException {
        super.keepAnyAssociatedFiles(storer);
        DataSource dataSourceValue = this.getDataSourceValue();
        if (dataSourceValue != null) {
            String filename = this.getFilename();
            storer.keepFile(filename);
        }
    }
}

