/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.image.ImageIO;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;

public class ImageProperty
extends ObjectProperty {
    public ImageProperty(Element owner, String name, Image defaultValue) {
        super(owner, name, defaultValue, Image.class);
    }

    public Image getImageValue() {
        return (Image)this.getValue();
    }

    private String getCodecName(String path) {
        String extension = path.substring(path.lastIndexOf(46) + 1);
        return ImageIO.mapExtensionToCodecName(extension);
    }

    @Override
    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        this.m_associatedFileKey = null;
        String filename = this.getFilename(this.getNodeText(node));
        InputStream is = loader.readFile(filename);
        this.set(ImageIO.load(this.getCodecName(filename), is));
        loader.closeCurrentFile();
        try {
            this.m_associatedFileKey = loader.getKeepKey(filename);
        }
        catch (KeepFileNotSupportedException kfnse) {
            this.m_associatedFileKey = null;
        }
    }

    @Override
    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Object associatedFileKey;
        Image imageValue = this.getImageValue();
        String codecName = "png";
        String extension = "png";
        String filename = String.valueOf(this.getName()) + "." + extension;
        try {
            associatedFileKey = storer.getKeepKey(filename);
        }
        catch (KeepFileNotSupportedException kfnse) {
            associatedFileKey = null;
        }
        if (this.m_associatedFileKey == null || !this.m_associatedFileKey.equals(associatedFileKey)) {
            this.m_associatedFileKey = null;
            OutputStream os = storer.createFile(filename, false);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                ImageIO.store(codecName, dos, imageValue);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            dos.flush();
            storer.closeCurrentFile();
            this.m_associatedFileKey = associatedFileKey;
        } else if (storer.isKeepFileSupported()) {
            try {
                storer.keepFile(filename);
            }
            catch (KeepFileNotSupportedException kfnse) {
                throw new Error(storer + " " + Messages.getString("returns_true_for_isKeepFileSupported____but_then_throws_") + kfnse);
            }
            catch (KeepFileDoesNotExistException kfdne) {
                throw new ExceptionWrapper(kfdne, filename);
            }
        }
        node.appendChild(this.createNodeForString(document, "java.io.File[" + filename + "]"));
    }

    @Override
    public void keepAnyAssociatedFiles(DirectoryTreeStorer storer) throws KeepFileNotSupportedException, KeepFileDoesNotExistException {
        super.keepAnyAssociatedFiles(storer);
        Image imageValue = this.getImageValue();
        if (imageValue instanceof RenderedImage) {
            String extension = "png";
            String filename = String.valueOf(this.getName()) + "." + extension;
            storer.keepFile(filename);
        }
    }
}

