/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.io.VFB;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.lang.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;

public class IntArrayProperty
extends ObjectProperty {
    public IntArrayProperty(Element owner, String name, int[] defaultValue) {
        super(owner, name, defaultValue, int[].class);
    }

    public int[] getIntArrayValue() {
        return (int[])this.getValue();
    }

    public int size() {
        int[] value = this.getIntArrayValue();
        if (value != null) {
            return value.length;
        }
        return 0;
    }

    @Override
    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        this.m_associatedFileKey = null;
        String filename = this.getFilename(this.getNodeText(node));
        String extension = filename.substring(filename.lastIndexOf(46) + 1);
        InputStream is = loader.readFile(filename);
        int[] indicesValue = extension.equalsIgnoreCase("vfb") ? VFB.loadIndices(is) : IndexedTriangleArray.loadIndices(is);
        loader.closeCurrentFile();
        this.set(indicesValue);
        try {
            this.m_associatedFileKey = loader.getKeepKey(filename);
        }
        catch (KeepFileNotSupportedException kfnse) {
            this.m_associatedFileKey = null;
        }
    }

    @Override
    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Object associatedFileKey;
        int[] indicesValue = this.getIntArrayValue();
        String filename = "indices.bin";
        try {
            associatedFileKey = storer.getKeepKey(filename);
        }
        catch (KeepFileNotSupportedException kfnse) {
            associatedFileKey = null;
        }
        if (this.m_associatedFileKey == null || !this.m_associatedFileKey.equals(associatedFileKey)) {
            this.m_associatedFileKey = null;
            OutputStream os = storer.createFile(filename, true);
            IndexedTriangleArray.storeIndices(indicesValue, os);
            storer.closeCurrentFile();
            this.m_associatedFileKey = associatedFileKey;
        } else if (storer.isKeepFileSupported()) {
            try {
                storer.keepFile(filename);
            }
            catch (KeepFileNotSupportedException kfnse) {
                throw new Error(storer + " " + Messages.getString("returns_true_for_isKeepFileSupported____but_then_throws_") + kfnse);
            }
            catch (KeepFileDoesNotExistException kfdne) {
                throw new ExceptionWrapper(kfdne, filename);
            }
        }
        node.appendChild(this.createNodeForString(document, "java.io.File[" + filename + "]"));
    }

    @Override
    public void keepAnyAssociatedFiles(DirectoryTreeStorer storer) throws KeepFileNotSupportedException, KeepFileDoesNotExistException {
        super.keepAnyAssociatedFiles(storer);
        String filename = "indices.bin";
        storer.keepFile(filename);
    }
}

