/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.math.Matrix33;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Matrix33Property
extends ObjectProperty {
    public Matrix33Property(Element owner, String name, Matrix3d defaultValue) {
        super(owner, name, defaultValue, Matrix3d.class);
    }

    public Matrix3d getMatrix3dValue() {
        return (Matrix3d)this.getValue();
    }

    public Matrix33 getMatrix33Value() {
        Matrix3d m = this.getMatrix3dValue();
        if (m == null || m instanceof Matrix33) {
            return (Matrix33)m;
        }
        return new Matrix33(m);
    }

    @Override
    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        Matrix3d m = new Matrix3d();
        NodeList rowNodeList = node.getElementsByTagName("row");
        int i = 0;
        while (i < 3) {
            org.w3c.dom.Element rowNode = (org.w3c.dom.Element)rowNodeList.item(i);
            NodeList itemNodeList = rowNode.getElementsByTagName("item");
            int j = 0;
            while (j < 3) {
                Node itemNode = itemNodeList.item(j);
                m.setElement(i, j, Double.parseDouble(this.getNodeText(itemNode)));
                ++j;
            }
            ++i;
        }
        this.set(m);
    }

    @Override
    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Matrix33 m = this.getMatrix33Value();
        int rowIndex = 0;
        while (rowIndex < 3) {
            org.w3c.dom.Element rowNode = document.createElement("row");
            int colIndex = 0;
            while (colIndex < 3) {
                org.w3c.dom.Element itemNode = document.createElement("item");
                itemNode.appendChild(this.createNodeForString(document, Double.toString(m.getElement(rowIndex, colIndex))));
                rowNode.appendChild(itemNode);
                ++colIndex;
            }
            node.appendChild(rowNode);
            ++rowIndex;
        }
    }
}

