/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.math.Matrix44;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Matrix44Property
extends ObjectProperty {
    public Matrix44Property(Element owner, String name, Matrix4d defaultValue) {
        super(owner, name, defaultValue, Matrix4d.class);
    }

    public Matrix4d getMatrix4dValue() {
        return (Matrix4d)this.getValue();
    }

    public Matrix44 getMatrix44Value() {
        Matrix4d m = this.getMatrix4dValue();
        if (m == null || m instanceof Matrix44) {
            return (Matrix44)m;
        }
        return new Matrix44(m);
    }

    @Override
    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        Matrix4d m = new Matrix4d();
        NodeList rowNodeList = node.getElementsByTagName("row");
        int i = 0;
        while (i < 4) {
            org.w3c.dom.Element rowNode = (org.w3c.dom.Element)rowNodeList.item(i);
            NodeList itemNodeList = rowNode.getElementsByTagName("item");
            int j = 0;
            while (j < 4) {
                Node itemNode = itemNodeList.item(j);
                m.setElement(i, j, Double.parseDouble(this.getNodeText(itemNode)));
                ++j;
            }
            ++i;
        }
        this.set(m);
    }

    @Override
    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Matrix44 m = this.getMatrix44Value();
        int rowIndex = 0;
        while (rowIndex < 4) {
            org.w3c.dom.Element rowNode = document.createElement("row");
            int colIndex = 0;
            while (colIndex < 4) {
                org.w3c.dom.Element itemNode = document.createElement("item");
                itemNode.appendChild(this.createNodeForString(document, Double.toString(m.getElement(rowIndex, colIndex))));
                rowNode.appendChild(itemNode);
                ++colIndex;
            }
            node.appendChild(rowNode);
            ++rowIndex;
        }
    }
}

