/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.math.Vector3;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Vector3Property
extends ObjectProperty {
    public Vector3Property(Element owner, String name, Vector3d defaultValue) {
        super(owner, name, defaultValue, Vector3d.class);
    }

    public Vector3d getVector3dValue() {
        return (Vector3d)this.getValue();
    }

    public Vector3 getVector3Value() {
        Vector3d v = this.getVector3dValue();
        if (v == null || v instanceof Vector3) {
            return (Vector3)v;
        }
        return new Vector3((Tuple3d)v);
    }

    @Override
    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        Node xNode = node.getElementsByTagName("x").item(0);
        Node yNode = node.getElementsByTagName("y").item(0);
        Node zNode = node.getElementsByTagName("z").item(0);
        float x = Float.parseFloat(this.getNodeText(xNode));
        float y = Float.parseFloat(this.getNodeText(yNode));
        float z = Float.parseFloat(this.getNodeText(zNode));
        this.set(new Vector3d((double)x, (double)y, (double)z));
    }

    @Override
    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Vector3 v = this.getVector3Value();
        org.w3c.dom.Element xNode = document.createElement("x");
        xNode.appendChild(this.createNodeForString(document, Double.toString(v.x)));
        node.appendChild(xNode);
        org.w3c.dom.Element yNode = document.createElement("y");
        yNode.appendChild(this.createNodeForString(document, Double.toString(v.y)));
        node.appendChild(yNode);
        org.w3c.dom.Element zNode = document.createElement("z");
        zNode.appendChild(this.createNodeForString(document, Double.toString(v.z)));
        node.appendChild(zNode);
    }
}

