/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.VertexGeometry;
import edu.cmu.cs.stage3.alice.scenegraph.io.VFB;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;

public class VertexArrayProperty
extends ObjectArrayProperty {
    public VertexArrayProperty(Element owner, String name, Vertex3d[] defaultValue) {
        super(owner, name, defaultValue, (Class)Vertex3d[].class);
    }

    public Vertex3d[] getVertexArrayValue() {
        return (Vertex3d[])this.getArrayValue();
    }

    @Override
    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        this.m_associatedFileKey = null;
        String filename = this.getFilename(this.getNodeText(node));
        String extension = filename.substring(filename.lastIndexOf(46) + 1);
        InputStream is = loader.readFile(filename);
        Vertex3d[] verticesValue = extension.equalsIgnoreCase("vfb") ? VFB.loadVertices(is) : VertexGeometry.loadVertices(is);
        loader.closeCurrentFile();
        this.set(verticesValue);
        try {
            this.m_associatedFileKey = loader.getKeepKey(filename);
        }
        catch (KeepFileNotSupportedException kfnse) {
            this.m_associatedFileKey = null;
        }
    }

    @Override
    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Object associatedFileKey;
        Vertex3d[] verticesValue = this.getVertexArrayValue();
        String filename = "vertices.bin";
        try {
            associatedFileKey = storer.getKeepKey(filename);
        }
        catch (KeepFileNotSupportedException kfnse) {
            associatedFileKey = null;
        }
        if (this.m_associatedFileKey == null || !this.m_associatedFileKey.equals(associatedFileKey)) {
            this.m_associatedFileKey = null;
            OutputStream os = storer.createFile(filename, true);
            VertexGeometry.storeVertices(verticesValue, os);
            storer.closeCurrentFile();
            this.m_associatedFileKey = associatedFileKey;
        } else if (storer.isKeepFileSupported()) {
            try {
                storer.keepFile(filename);
            }
            catch (KeepFileNotSupportedException kfnse) {
                throw new Error(storer + " returns true for isKeepFileSupported(), but then throws " + kfnse);
            }
            catch (KeepFileDoesNotExistException kfdne) {
                throw new ExceptionWrapper(kfdne, filename);
            }
        }
        node.appendChild(this.createNodeForString(document, "java.io.File[" + filename + "]"));
    }

    @Override
    public void keepAnyAssociatedFiles(DirectoryTreeStorer storer) throws KeepFileNotSupportedException, KeepFileDoesNotExistException {
        super.keepAnyAssociatedFiles(storer);
        String filename = "vertices.bin";
        storer.keepFile(filename);
    }
}

