/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.question;

import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.question.SubjectObjectQuestion;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;

public class IsCollidingWith
extends SubjectObjectQuestion {
    private World m_world = null;

    @Override
    public Class getValueClass() {
        return Boolean.class;
    }

    @Override
    protected Object getValue(Transformable subjectValue, Transformable objectValue) {
        World world = subjectValue.getWorld();
        Visual[] subjectSGVisuals = subjectValue.getAllSceneGraphVisuals();
        Visual[] objectSGVisuals = subjectValue.getAllSceneGraphVisuals();
        Visual[][] collisions = world.getCollisions();
        int i = 0;
        while (i < collisions.length) {
            Visual[] pair = collisions[i];
            Sandbox a = ((Model)pair[0].getBonus()).getSandbox();
            Sandbox b = ((Model)pair[1].getBonus()).getSandbox();
            if (a == subjectValue ? b == objectValue : b == subjectValue && a == objectValue) {
                return Boolean.TRUE;
            }
            ++i;
        }
        return Boolean.FALSE;
    }

    @Override
    protected void started(World world, double time) {
        super.started(world, time);
        this.m_world = world;
        this.m_world.addCollisionManagementFor(this.subject.getTransformableValue());
        this.m_world.addCollisionManagementFor(this.object.getTransformableValue());
    }

    @Override
    protected void stopped(World world, double time) {
        super.stopped(world, time);
        if (this.m_world != world) {
            throw new Error();
        }
        this.m_world.removeCollisionManagementFor(this.subject.getTransformableValue());
        this.m_world.removeCollisionManagementFor(this.object.getTransformableValue());
        this.m_world = null;
    }
}

