/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.property.ReferenceFrameProperty;
import edu.cmu.cs.stage3.alice.core.property.Vector3Property;
import edu.cmu.cs.stage3.alice.core.response.TransformResponse;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.MathUtilities;
import javax.vecmath.Vector3d;

public class AbstractPointAtConstraint
extends TransformResponse {
    public final ReferenceFrameProperty target = new ReferenceFrameProperty((Element)this, "target", null);
    public final Vector3Property offset = new Vector3Property(this, "offset", null);
    public final Vector3Property upGuide = new Vector3Property(this, "upGuide", null);

    public abstract class RuntimeAbstractPointAtConstraint
    extends TransformResponse.RuntimeTransformResponse {
        private Vector3d m_upGuide;
        private Vector3d m_offset;
        private ReferenceFrame m_target;
        private boolean m_onlyAffectYaw;

        public RuntimeAbstractPointAtConstraint() {
            super(AbstractPointAtConstraint.this);
        }

        protected abstract boolean onlyAffectYaw();

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.m_target = AbstractPointAtConstraint.this.target.getReferenceFrameValue();
            this.m_offset = AbstractPointAtConstraint.this.offset.getVector3Value();
            this.m_upGuide = AbstractPointAtConstraint.this.upGuide.getVector3Value();
            this.m_onlyAffectYaw = this.onlyAffectYaw();
            if (this.m_target == null) {
                throw new SimulationPropertyException(Messages.getString("target_value_must_not_be_null_"), null, AbstractPointAtConstraint.this.target);
            }
            if (this.m_target == this.m_subject) {
                throw new SimulationPropertyException(Messages.getString("target_value_must_not_be_equal_to_the_subject_value_"), this.getCurrentStack(), AbstractPointAtConstraint.this.target);
            }
        }

        protected boolean isTurnAroundNecessary() {
            return false;
        }

        @Override
        public void update(double t) {
            super.update(t);
            this.m_subject.pointAtRightNow(this.m_target, this.m_offset, this.m_upGuide, this.m_asSeenBy, this.m_onlyAffectYaw);
            if (this.isTurnAroundNecessary()) {
                this.m_subject.rotateRightNow(MathUtilities.getYAxis(), 0.5);
            }
        }
    }
}

