/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.response.TransformAnimation;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.stage3.math.MathUtilities;
import javax.vecmath.Vector3d;

public abstract class AbstractPositionAnimation
extends TransformAnimation {

    public abstract class RuntimeAbstractPositionAnimation
    extends TransformAnimation.RuntimeTransformAnimation
    implements AbsoluteTransformationListener {
        private Vector3d m_positionBegin;
        private Vector3d m_positionEnd;

        public RuntimeAbstractPositionAnimation() {
            super(AbstractPositionAnimation.this);
        }

        protected abstract Vector3d getPositionBegin();

        protected abstract Vector3d getPositionEnd();

        @Override
        public void absoluteTransformationChanged(AbsoluteTransformationEvent absoluteTransformationEvent) {
            this.m_positionEnd = null;
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            if (this.m_asSeenBy == null) {
                this.m_asSeenBy = this.m_subject.vehicle.getReferenceFrameValue();
            }
            this.m_positionBegin = this.getPositionBegin();
            this.m_positionEnd = null;
            this.m_asSeenBy.addAbsoluteTransformationListener(this);
        }

        @Override
        public void update(double t) {
            super.update(t);
            if (this.m_positionEnd == null) {
                this.m_positionEnd = this.getPositionEnd();
            }
            this.m_subject.setPositionRightNow(MathUtilities.interpolate(this.m_positionBegin, this.m_positionEnd, this.getPortion(t)), ReferenceFrame.ABSOLUTE);
        }

        @Override
        public void epilogue(double t) {
            super.epilogue(t);
            if (this.m_asSeenBy != null) {
                this.m_asSeenBy.removeAbsoluteTransformationListener(this);
            }
        }
    }
}

