/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Amount;
import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.criterion.ElementNameContainsCriterion;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.AmountProperty;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import edu.cmu.cs.stage3.alice.core.response.Animation;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.util.HowMuch;
import javax.vecmath.Vector3d;

public class AbstractWalkAnimation
extends Animation
implements PropertyListener {
    public final TransformableProperty subject = new TransformableProperty((Element)this, "subject", null);
    public final AmountProperty stepAmount = new AmountProperty(this, "step size", Amount.NORMAL);
    public final AmountProperty bounceAmount = new AmountProperty(this, "bounce size", Amount.NORMAL);
    public final AmountProperty armAmount = new AmountProperty(this, "arm swing size", Amount.NORMAL);
    public final BooleanProperty swingArms = new BooleanProperty(this, "swing arms", Boolean.TRUE);
    public final NumberProperty stepSpeed = new NumberProperty(this, "stepsPerSecond", new Double(1.5));

    public AbstractWalkAnimation() {
        this.duration.set(new Double(Double.NaN));
        this.duration.addPropertyListener(this);
        this.stepSpeed.addPropertyListener(this);
    }

    @Override
    protected void propertyChanged(Property property, Object value) {
        super.propertyChanged(property, value);
        if (property.equals(this.duration)) {
            if (!Double.isNaN((Double)value)) {
                this.stepSpeed.set(new Double(Double.NaN));
            }
        } else if (property.equals(this.stepSpeed) && !Double.isNaN((Double)value)) {
            this.duration.set(new Double(Double.NaN));
        }
    }

    public class RuntimeAbstractWalkAnimation
    extends Animation.RuntimeAnimation {
        protected Transformable subject;
        protected static final double normalContactAngle = 0.46;
        protected static final double normalBackRecoilAngle = 1.3;
        protected static final double normalFrontRecoilAngle = 0.5;
        protected double upperArmAngle = 0.3;
        protected double lowerArmAngle = 0.1;
        protected double portionContact = 0.3333333333333333;
        protected double portionRecoil = 0.16666666666666666;
        protected double portionPassing = 0.3333333333333333;
        protected double portionHighPoint = 0.16666666666666666;
        protected double contactAngle = 0.245;
        protected double recoilBackLowerAngle = 0.6;
        protected double recoilFrontUpperAngle = 0.3;
        protected double passingFrontUpperAngle = 0.0;
        protected double passingFrontLowerAngle = 0.0;
        protected double passingFrontFootAngle = 0.0;
        protected double passingBackLowerAngle = 0.2;
        protected double highPointFrontUpperAngle = 0.2;
        protected double highPointBackUpperAngle = 0.7;
        protected double highPointBackLowerAngle = 0.0;
        protected double heightFromGround = 0.0;
        protected double initialBoundingBoxHeight = 0.0;
        protected boolean firstTimeContact = true;
        protected boolean firstTimeRecoil = true;
        protected boolean firstTimePassing = true;
        protected boolean firstTimeHighPoint = true;
        protected Transformable rightUpper = null;
        protected Transformable rightLower = null;
        protected Transformable rightFoot = null;
        protected Transformable leftUpper = null;
        protected Transformable leftLower = null;
        protected Transformable leftFoot = null;
        protected Transformable rightUpperArm = null;
        protected Transformable rightLowerArm = null;
        protected Transformable leftUpperArm = null;
        protected Transformable leftLowerArm = null;
        protected double totalLength = 0.0;
        protected double upperLength = 0.0;
        protected double lowerLength = 0.0;
        protected double footLength = 0.0;
        protected double footHorizLength = 0.0;
        protected Matrix33 rightUpperInitialOrient = null;
        protected Matrix33 rightLowerInitialOrient = null;
        protected Matrix33 rightFootInitialOrient = null;
        protected Matrix33 leftUpperInitialOrient = null;
        protected Matrix33 leftLowerInitialOrient = null;
        protected Matrix33 leftFootInitialOrient = null;
        protected Matrix33 rightUpperArmInitialOrient = null;
        protected Matrix33 rightLowerArmInitialOrient = null;
        protected Matrix33 leftUpperArmInitialOrient = null;
        protected Matrix33 leftLowerArmInitialOrient = null;
        protected Vector3 initialPos = null;
        protected Matrix33 defaultOrient = new Matrix33();
        protected Matrix33 frontUpperContactOrient = new Matrix33();
        protected Matrix33 frontLowerContactOrient = new Matrix33();
        protected Matrix33 frontFootContactOrient = new Matrix33();
        protected Matrix33 backUpperContactOrient = new Matrix33();
        protected Matrix33 backLowerContactOrient = new Matrix33();
        protected Matrix33 backFootContactOrient = new Matrix33();
        protected Vector3 contactPos = null;
        protected double distanceToMoveContact = 0.0;
        protected Matrix33 frontUpperRecoilOrient = new Matrix33();
        protected Matrix33 frontLowerRecoilOrient = new Matrix33();
        protected Matrix33 frontFootRecoilOrient = new Matrix33();
        protected Matrix33 backUpperRecoilOrient = new Matrix33();
        protected Matrix33 backLowerRecoilOrient = new Matrix33();
        protected Matrix33 backFootRecoilOrient = new Matrix33();
        protected Vector3 recoilPos = null;
        protected double distanceToMoveRecoil = 0.0;
        protected Matrix33 frontUpperPassingOrient = new Matrix33();
        protected Matrix33 frontLowerPassingOrient = new Matrix33();
        protected Matrix33 frontFootPassingOrient = new Matrix33();
        protected Matrix33 backUpperPassingOrient = new Matrix33();
        protected Matrix33 backLowerPassingOrient = new Matrix33();
        protected Matrix33 backFootPassingOrient = new Matrix33();
        protected Vector3 passingPos = null;
        protected double distanceToMovePassing = 0.0;
        protected Matrix33 frontUpperHighPointOrient = new Matrix33();
        protected Matrix33 frontLowerHighPointOrient = new Matrix33();
        protected Matrix33 frontFootHighPointOrient = new Matrix33();
        protected Matrix33 backUpperHighPointOrient = new Matrix33();
        protected Matrix33 backLowerHighPointOrient = new Matrix33();
        protected Matrix33 backFootHighPointOrient = new Matrix33();
        protected Vector3 highPointPos = null;
        protected double distanceToMoveHighPoint = 0.0;
        protected Matrix33 frontUpperArmOrient = new Matrix33();
        protected Matrix33 frontLowerArmOrient = new Matrix33();
        protected Matrix33 backUpperArmOrient = new Matrix33();
        protected Matrix33 backLowerArmOrient = new Matrix33();
        protected Matrix33 rightUpperCurrentOrient = new Matrix33();
        protected Matrix33 rightLowerCurrentOrient = new Matrix33();
        protected Matrix33 rightFootCurrentOrient = new Matrix33();
        protected Matrix33 leftUpperCurrentOrient = new Matrix33();
        protected Matrix33 leftLowerCurrentOrient = new Matrix33();
        protected Matrix33 leftFootCurrentOrient = new Matrix33();
        protected Matrix33 rightUpperArmCurrentOrient = new Matrix33();
        protected Matrix33 rightLowerArmCurrentOrient = new Matrix33();
        protected Matrix33 leftUpperArmCurrentOrient = new Matrix33();
        protected Matrix33 leftLowerArmCurrentOrient = new Matrix33();

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.resetData();
            this.subject = AbstractWalkAnimation.this.subject.getTransformableValue();
            this.recoilFrontUpperAngle = 0.5;
            if (AbstractWalkAnimation.this.armAmount.getValue().equals(Amount.HUGE)) {
                this.upperArmAngle = 0.8;
                this.lowerArmAngle = 1.2;
            } else if (AbstractWalkAnimation.this.armAmount.getValue().equals(Amount.BIG)) {
                this.upperArmAngle = 0.675;
                this.lowerArmAngle = 0.925;
            } else if (AbstractWalkAnimation.this.armAmount.getValue().equals(Amount.NORMAL)) {
                this.upperArmAngle = 0.55;
                this.lowerArmAngle = 0.65;
            } else if (AbstractWalkAnimation.this.armAmount.getValue().equals(Amount.LITTLE)) {
                this.upperArmAngle = 0.425;
                this.lowerArmAngle = 0.375;
            } else if (AbstractWalkAnimation.this.armAmount.getValue().equals(Amount.TINY)) {
                this.upperArmAngle = 0.3;
                this.lowerArmAngle = 0.1;
            }
            if (AbstractWalkAnimation.this.bounceAmount.getValue().equals(Amount.HUGE)) {
                this.recoilFrontUpperAngle = 0.5;
                this.recoilBackLowerAngle = 2.0;
            } else if (AbstractWalkAnimation.this.bounceAmount.getValue().equals(Amount.BIG)) {
                this.recoilFrontUpperAngle = 0.37;
                this.recoilBackLowerAngle = 1.625;
            } else if (AbstractWalkAnimation.this.bounceAmount.getValue().equals(Amount.NORMAL)) {
                this.recoilFrontUpperAngle = 0.25;
                this.recoilBackLowerAngle = 1.25;
            } else if (AbstractWalkAnimation.this.bounceAmount.getValue().equals(Amount.LITTLE)) {
                this.recoilFrontUpperAngle = 0.12;
                this.recoilBackLowerAngle = 0.875;
            } else if (AbstractWalkAnimation.this.bounceAmount.getValue().equals(Amount.TINY)) {
                this.recoilFrontUpperAngle = 0.0;
                this.recoilBackLowerAngle = 0.5;
            }
            if (AbstractWalkAnimation.this.stepAmount.getValue().equals(Amount.HUGE)) {
                this.contactAngle = 0.6900000000000001;
            } else if (AbstractWalkAnimation.this.stepAmount.getValue().equals(Amount.BIG)) {
                this.contactAngle = 0.5750000000000001;
            } else if (AbstractWalkAnimation.this.stepAmount.getValue().equals(Amount.NORMAL)) {
                this.contactAngle = 0.46;
            } else if (AbstractWalkAnimation.this.stepAmount.getValue().equals(Amount.LITTLE)) {
                this.contactAngle = 0.34500000000000003;
            } else if (AbstractWalkAnimation.this.stepAmount.getValue().equals(Amount.TINY)) {
                this.contactAngle = 0.23;
            }
            this.findLegs();
            this.findArms();
            this.setLegLengths();
            this.setInitialOrientations();
            this.setContactData();
            this.setRecoilData();
            this.setPassingData();
            this.setHighPointData();
            this.setArmData();
        }

        public void stepRight(double portion, boolean lastStep) {
            this.step(this.rightUpper, portion, lastStep);
        }

        public void stepLeft(double portion, boolean lastStep) {
            this.step(this.leftUpper, portion, lastStep);
        }

        protected void step(Transformable leg, double portion, boolean lastStep) {
            this.adjustHeight();
            if (AbstractWalkAnimation.this.swingArms.getValue().equals(Boolean.TRUE)) {
                this.updateArms(leg, portion, lastStep);
            }
            if (portion < this.portionContact) {
                if (this.firstTimeContact) {
                    this.firstTimeContact = false;
                    this.firstTimeHighPoint = true;
                    this.getCurrentOrientations();
                }
                this.updateContact(leg, portion /= this.portionContact);
            } else if (portion < this.portionContact + this.portionRecoil) {
                if (this.firstTimeRecoil) {
                    this.firstTimeRecoil = false;
                    this.firstTimeContact = true;
                    this.getCurrentOrientations();
                }
                portion = (portion - this.portionContact) / this.portionRecoil;
                if (this.leftLower != null) {
                    this.updateRecoil(leg, portion);
                }
            } else if (portion < this.portionContact + this.portionRecoil + this.portionPassing) {
                if (this.firstTimePassing) {
                    this.firstTimePassing = false;
                    this.firstTimeRecoil = true;
                    this.getCurrentOrientations();
                }
                portion = (portion - this.portionContact - this.portionRecoil) / this.portionPassing;
                this.updatePassing(leg, portion);
            } else {
                if (this.firstTimeHighPoint) {
                    this.firstTimeHighPoint = false;
                    this.firstTimePassing = true;
                    this.getCurrentOrientations();
                }
                portion = (portion - this.portionContact - this.portionRecoil - this.portionPassing) / this.portionHighPoint;
                this.updateHighPoint(leg, portion, lastStep);
            }
            this.adjustHeight();
        }

        protected void adjustHeight() {
            double distanceAboveGround = 0.0;
            if (this.rightFoot != null && this.leftFoot != null) {
                double rightHeight = this.rightFoot.getBoundingBox((ReferenceFrame)this.subject.getWorld()).getCenterOfBottomFace().y;
                double leftHeight = this.leftFoot.getBoundingBox((ReferenceFrame)this.subject.getWorld()).getCenterOfBottomFace().y;
                distanceAboveGround = Math.min(rightHeight, leftHeight);
            } else {
                distanceAboveGround = this.subject.getBoundingBox((ReferenceFrame)this.subject.getWorld()).getCenterOfBottomFace().y;
            }
            double roundHeight = Math.round(this.subject.getBoundingBox((ReferenceFrame)this.subject.getWorld()).getCenterOfBottomFace().y);
            int level = (int)Math.round(roundHeight / 256.0);
            this.subject.moveRightNow(Direction.DOWN, distanceAboveGround - 256.0 * (double)level, this.subject.getWorld());
        }

        public void getCurrentOrientations() {
            if (this.rightUpper != null) {
                this.rightUpperCurrentOrient = this.rightUpper.getOrientationAsAxes();
            }
            if (this.rightLower != null) {
                this.rightLowerCurrentOrient = this.rightLower.getOrientationAsAxes();
            }
            if (this.rightFoot != null) {
                this.rightFootCurrentOrient = this.rightFoot.getOrientationAsAxes();
            }
            if (this.leftUpper != null) {
                this.leftUpperCurrentOrient = this.leftUpper.getOrientationAsAxes();
            }
            if (this.leftLower != null) {
                this.leftLowerCurrentOrient = this.leftLower.getOrientationAsAxes();
            }
            if (this.leftFoot != null) {
                this.leftFootCurrentOrient = this.leftFoot.getOrientationAsAxes();
            }
            if (this.rightUpperArm != null) {
                this.rightUpperArmCurrentOrient = this.rightUpperArm.getOrientationAsAxes();
            }
            if (this.rightLowerArm != null) {
                this.rightLowerArmCurrentOrient = this.rightLowerArm.getOrientationAsAxes();
            }
            if (this.leftUpperArm != null) {
                this.leftUpperArmCurrentOrient = this.leftUpperArm.getOrientationAsAxes();
            }
            if (this.leftLowerArm != null) {
                this.leftLowerArmCurrentOrient = this.leftLowerArm.getOrientationAsAxes();
            }
        }

        public void findLegs() {
            Element[] legs = this.subject.search(new ElementNameContainsCriterion("UpperLeg"));
            int i = 0;
            while (i < legs.length) {
                if (legs[i].getKey().indexOf("leftU") != -1 && legs[i] instanceof Transformable) {
                    this.leftUpper = (Transformable)legs[i];
                    this.leftLower = this.getTransformableChild(this.leftUpper);
                    if (this.leftLower.name.getStringValue().indexOf("Foot") != -1) {
                        this.leftFoot = this.leftLower;
                        this.leftLower = null;
                    }
                    this.leftFoot = this.leftLower != null ? this.getTransformableChild(this.leftLower) : this.getTransformableChild(this.leftUpper);
                } else if (legs[i].getKey().indexOf("rightU") != -1 && legs[i] instanceof Transformable) {
                    this.rightUpper = (Transformable)legs[i];
                    this.rightLower = this.getTransformableChild(this.rightUpper);
                    if (this.rightLower.name.getStringValue().indexOf("Foot") != -1) {
                        this.rightFoot = this.rightLower;
                        this.rightLower = null;
                    }
                    this.rightFoot = this.rightLower != null ? this.getTransformableChild(this.rightLower) : this.getTransformableChild(this.rightUpper);
                }
                ++i;
            }
        }

        public void findArms() {
            Element[] arms = this.subject.search(new ElementNameContainsCriterion("UpperArm"));
            int i = 0;
            while (i < arms.length) {
                if (arms[i].getKey().indexOf("left") != -1 && arms[i] instanceof Transformable) {
                    this.leftUpperArm = (Transformable)arms[i];
                    this.leftLowerArm = this.getTransformableChild(this.leftUpperArm);
                    if (this.leftLowerArm != null && this.leftLowerArm.name.getStringValue().indexOf("Hand") != -1) {
                        this.leftLowerArm = null;
                    }
                } else if (arms[i].getKey().indexOf("right") != -1 && arms[i] instanceof Transformable) {
                    this.rightUpperArm = (Transformable)arms[i];
                    this.rightLowerArm = this.getTransformableChild(this.rightUpperArm);
                    if (this.rightLowerArm != null && this.rightLowerArm.name.getStringValue().indexOf("Hand") != -1) {
                        this.rightLowerArm = null;
                    }
                }
                ++i;
            }
        }

        public void resetData() {
            this.contactAngle = 0.245;
            this.recoilBackLowerAngle = 0.2;
            this.recoilFrontUpperAngle = 0.4;
            this.passingFrontUpperAngle = 0.0;
            this.passingFrontLowerAngle = 0.0;
            this.passingFrontFootAngle = 0.0;
            this.passingBackLowerAngle = 0.2;
            this.highPointFrontUpperAngle = 0.2;
            this.highPointBackUpperAngle = 0.7;
            this.highPointBackLowerAngle = 0.0;
            this.frontUpperContactOrient = new Matrix33();
            this.frontLowerContactOrient = new Matrix33();
            this.frontFootContactOrient = new Matrix33();
            this.backUpperContactOrient = new Matrix33();
            this.backLowerContactOrient = new Matrix33();
            this.backFootContactOrient = new Matrix33();
            this.contactPos = null;
            this.distanceToMoveContact = 0.0;
            this.frontUpperRecoilOrient = new Matrix33();
            this.frontLowerRecoilOrient = new Matrix33();
            this.frontFootRecoilOrient = new Matrix33();
            this.backUpperRecoilOrient = new Matrix33();
            this.backLowerRecoilOrient = new Matrix33();
            this.backFootRecoilOrient = new Matrix33();
            this.recoilPos = null;
            this.distanceToMoveRecoil = 0.0;
            this.frontUpperPassingOrient = new Matrix33();
            this.frontLowerPassingOrient = new Matrix33();
            this.frontFootPassingOrient = new Matrix33();
            this.backUpperPassingOrient = new Matrix33();
            this.backLowerPassingOrient = new Matrix33();
            this.backFootPassingOrient = new Matrix33();
            this.passingPos = null;
            this.distanceToMovePassing = 0.0;
            this.frontUpperHighPointOrient = new Matrix33();
            this.frontLowerHighPointOrient = new Matrix33();
            this.frontFootHighPointOrient = new Matrix33();
            this.backUpperHighPointOrient = new Matrix33();
            this.backLowerHighPointOrient = new Matrix33();
            this.backFootHighPointOrient = new Matrix33();
            this.highPointPos = null;
            this.distanceToMoveHighPoint = 0.0;
        }

        public void setLegLengths() {
            Vector3 top = new Vector3();
            Vector3d bottom = new Vector3d();
            this.footLength = 0.0;
            this.footHorizLength = 0.0;
            if (this.rightFoot != null) {
                top = this.rightFoot.getPosition(this.rightFoot);
                bottom = this.rightFoot.getBoundingBox(this.rightFoot).getCenterOfBottomFace();
                this.footLength = top.y - bottom.y;
                this.footHorizLength = bottom.z - top.z;
            }
            this.lowerLength = 0.0;
            if (this.rightLower != null) {
                top = this.rightLower.getPosition(this.rightLower);
                bottom = this.rightFoot != null ? this.rightFoot.getPosition(this.rightLower) : this.rightLower.getBoundingBox(this.rightLower).getCenterOfBottomFace();
                this.lowerLength = top.y - bottom.y;
            }
            this.upperLength = 0.0;
            if (this.rightUpper != null) {
                top = this.rightUpper.getPosition(this.rightUpper);
                bottom = this.rightLower != null ? this.rightLower.getPosition(this.rightUpper) : (this.rightFoot != null ? this.rightFoot.getPosition(this.rightLower) : this.rightUpper.getBoundingBox(this.rightUpper).getCenterOfBottomFace());
                this.upperLength = top.y - bottom.y;
            }
            this.totalLength = this.footLength + this.lowerLength + this.upperLength;
        }

        public double getStepLength() {
            double stepLength = this.totalLength * Math.sin(this.contactAngle) * 1.5;
            if (stepLength == 0.0) {
                stepLength = 1.0;
            }
            return stepLength;
        }

        public void setInitialOrientations() {
            if (this.rightUpper != null) {
                this.rightUpperInitialOrient = this.rightUpper.getOrientationAsAxes(this.rightUpper);
            }
            if (this.rightLower != null) {
                this.rightLowerInitialOrient = this.rightLower.getOrientationAsAxes(this.rightLower);
            }
            if (this.rightFoot != null) {
                this.rightFootInitialOrient = this.rightFoot.getOrientationAsAxes(this.rightFoot);
            }
            if (this.leftUpper != null) {
                this.leftUpperInitialOrient = this.leftUpper.getOrientationAsAxes(this.leftUpper);
            }
            if (this.leftLower != null) {
                this.leftLowerInitialOrient = this.leftLower.getOrientationAsAxes(this.leftLower);
            }
            if (this.leftFoot != null) {
                this.leftFootInitialOrient = this.leftFoot.getOrientationAsAxes(this.leftFoot);
            }
            if (this.rightUpperArm != null) {
                this.rightUpperArmInitialOrient = this.rightUpperArm.getOrientationAsAxes(this.rightUpperArm);
            }
            if (this.rightLowerArm != null) {
                this.rightLowerArmInitialOrient = this.rightLowerArm.getOrientationAsAxes(this.rightLowerArm);
            }
            if (this.leftUpperArm != null) {
                this.leftUpperArmInitialOrient = this.leftUpperArm.getOrientationAsAxes(this.leftUpperArm);
            }
            if (this.leftLowerArm != null) {
                this.leftLowerArmInitialOrient = this.leftLowerArm.getOrientationAsAxes(this.leftLowerArm);
            }
            if (this.rightUpper != null && this.leftUpper != null) {
                Vector3 top = this.rightUpper.getPosition(this.rightUpper);
                Vector3d bottom = this.rightUpper.getBoundingBox(this.rightUpper).getCenterOfBottomFace();
                double offset = top.y - bottom.y - this.totalLength;
                top = this.leftUpper.getPosition(this.leftUpper);
                bottom = this.leftUpper.getBoundingBox(this.leftUpper).getCenterOfBottomFace();
                double offset2 = top.y - bottom.y - this.totalLength;
                if (offset2 > offset) {
                    offset = offset2;
                }
                this.initialPos = this.subject.getPosition(new Vector3d(0.0, offset, 0.0), this.subject.getWorld());
                this.heightFromGround = this.initialPos.y;
                this.initialBoundingBoxHeight = this.getCurrentLegHeight();
            }
        }

        public double getCurrentLegHeight() {
            if (this.rightUpper != null) {
                this.rightUpper.getBoundingBox(this.rightUpper.getWorld(), HowMuch.INSTANCE);
                double boundingBoxHeight = this.rightUpper.getBoundingBox(this.rightUpper.getWorld()).getHeight();
                double boundingBoxHeight2 = this.leftUpper.getBoundingBox(this.leftUpper.getWorld()).getHeight();
                if (boundingBoxHeight2 > boundingBoxHeight) {
                    boundingBoxHeight = boundingBoxHeight2;
                }
                return boundingBoxHeight;
            }
            return 0.0;
        }

        public void setContactData() {
            double rotationLower = 0.0;
            double rotationUpper = 0.0;
            if (this.leftLower == null || this.rightLower == null) {
                rotationUpper = this.contactAngle;
            } else {
                double lowerLegEffectiveLength = Math.sqrt(this.footHorizLength * this.footHorizLength + (this.lowerLength + this.footLength) * (this.lowerLength + this.footLength));
                double kneeAngle = (this.totalLength * this.totalLength - this.upperLength * this.upperLength - lowerLegEffectiveLength * lowerLegEffectiveLength) / (-2.0 * this.upperLength * lowerLegEffectiveLength);
                kneeAngle = Math.acos(kneeAngle);
                rotationLower = Math.PI - kneeAngle + Math.atan(this.footHorizLength / (this.footLength + this.lowerLength));
                rotationUpper = this.contactAngle - Math.asin(lowerLegEffectiveLength * Math.sin(kneeAngle) / this.totalLength);
                this.recoilBackLowerAngle += rotationLower;
                this.recoilFrontUpperAngle += this.contactAngle;
                this.passingFrontUpperAngle = this.recoilFrontUpperAngle;
                this.passingFrontLowerAngle = this.recoilFrontUpperAngle + 0.2;
                this.passingFrontFootAngle = 0.2;
                this.passingBackLowerAngle += this.recoilBackLowerAngle;
                this.highPointBackLowerAngle = this.passingBackLowerAngle / 2.0;
            }
            this.frontUpperContactOrient.rotateX(-1.0 * this.contactAngle);
            this.backUpperContactOrient.rotateX(rotationUpper);
            this.backLowerContactOrient.rotateX(rotationLower);
            this.distanceToMoveContact = this.totalLength - this.totalLength * Math.cos(this.contactAngle);
            this.contactPos = this.subject.getPosition(new Vector3d(0.0, -1.0 * this.distanceToMoveContact, 0.0), this.subject.getWorld());
        }

        public void setRecoilData() {
            this.frontUpperRecoilOrient.rotateX(-1.0 * this.recoilFrontUpperAngle);
            this.frontLowerRecoilOrient.rotateX(this.recoilFrontUpperAngle);
            this.backLowerRecoilOrient.rotateX(this.recoilBackLowerAngle);
            double distance = this.upperLength - this.upperLength * Math.cos(this.passingFrontUpperAngle) + this.lowerLength - this.lowerLength * Math.cos(this.passingFrontLowerAngle - this.passingFrontUpperAngle);
            this.recoilPos = this.subject.getPosition(new Vector3d(0.0, -1.0 * distance, 0.0), this.subject.getWorld());
        }

        public void setPassingData() {
            this.frontUpperPassingOrient.rotateX(-1.0 * this.passingFrontUpperAngle);
            this.frontLowerPassingOrient.rotateX(this.passingFrontLowerAngle);
            this.frontFootPassingOrient.rotateX(-1.0 * this.passingFrontFootAngle);
            this.backUpperPassingOrient.rotateX(-1.0 * this.passingFrontUpperAngle);
            this.backLowerPassingOrient.rotateX(this.passingBackLowerAngle);
            double distance = this.upperLength - this.upperLength * Math.cos(this.recoilFrontUpperAngle);
            this.passingPos = this.subject.getPosition(new Vector3d(0.0, -1.0 * distance, 0.0), this.subject.getWorld());
        }

        public void setHighPointData() {
            this.frontUpperHighPointOrient.rotateX(this.highPointFrontUpperAngle);
            this.backUpperHighPointOrient.rotateX(-1.0 * this.highPointBackUpperAngle);
            this.backLowerHighPointOrient.rotateX(this.highPointBackLowerAngle);
            double distance = this.totalLength - this.totalLength * Math.cos(this.highPointFrontUpperAngle);
            this.highPointPos = this.subject.getPosition(new Vector3d(0.0, -1.0 * distance, 0.0), this.subject.getWorld());
        }

        public void setArmData() {
            this.frontUpperArmOrient.rotateX(-1.0 * this.upperArmAngle);
            this.frontLowerArmOrient.rotateX(-1.0 * this.lowerArmAngle);
            this.backUpperArmOrient.rotateX(2.0 * this.upperArmAngle);
        }

        public Transformable getTransformableChild(Transformable parent) {
            if (parent == null) {
                return null;
            }
            Element[] legBits = parent.getChildren(Transformable.class);
            if (legBits.length == 1) {
                return (Transformable)legBits[0];
            }
            return null;
        }

        public void updateContact(Transformable leg, double portion) {
            if (portion <= 1.0 && leg != null) {
                if (leg.equals(this.rightUpper)) {
                    this.setQuaternion(this.rightUpper, this.rightUpperCurrentOrient, this.frontUpperContactOrient, portion);
                    this.setQuaternion(this.rightLower, this.rightLowerCurrentOrient, this.frontLowerContactOrient, portion);
                    this.setQuaternion(this.leftUpper, this.leftUpperCurrentOrient, this.backUpperContactOrient, portion);
                    this.setQuaternion(this.leftLower, this.leftLowerCurrentOrient, this.backLowerContactOrient, portion);
                } else {
                    this.setQuaternion(this.leftUpper, this.leftUpperCurrentOrient, this.frontUpperContactOrient, portion);
                    this.setQuaternion(this.leftLower, this.leftLowerCurrentOrient, this.frontLowerContactOrient, portion);
                    this.setQuaternion(this.rightUpper, this.rightUpperCurrentOrient, this.backUpperContactOrient, portion);
                    this.setQuaternion(this.rightLower, this.rightLowerCurrentOrient, this.backLowerContactOrient, portion);
                }
            }
        }

        public void updateRecoil(Transformable leg, double portion) {
            if (leg != null && portion <= 1.0) {
                if (leg.equals(this.rightUpper)) {
                    this.setQuaternion(this.rightUpper, this.rightUpperCurrentOrient, this.frontUpperRecoilOrient, portion);
                    this.setQuaternion(this.rightLower, this.rightLowerCurrentOrient, this.frontLowerRecoilOrient, portion);
                    this.setQuaternion(this.leftUpper, this.leftUpperCurrentOrient, this.backUpperRecoilOrient, portion);
                    this.setQuaternion(this.leftLower, this.leftLowerCurrentOrient, this.backLowerRecoilOrient, portion);
                } else {
                    this.setQuaternion(this.leftUpper, this.leftUpperCurrentOrient, this.frontUpperRecoilOrient, portion);
                    this.setQuaternion(this.leftLower, this.leftLowerCurrentOrient, this.frontLowerRecoilOrient, portion);
                    this.setQuaternion(this.rightUpper, this.rightUpperCurrentOrient, this.backUpperRecoilOrient, portion);
                    this.setQuaternion(this.rightLower, this.rightLowerCurrentOrient, this.backLowerRecoilOrient, portion);
                }
            }
        }

        public void updatePassing(Transformable leg, double portion) {
            if (leg != null && portion <= 1.0) {
                if (leg.equals(this.rightUpper)) {
                    this.setQuaternion(this.rightUpper, this.rightUpperCurrentOrient, this.frontUpperPassingOrient, portion);
                    this.setQuaternion(this.rightLower, this.rightLowerCurrentOrient, this.frontLowerPassingOrient, portion);
                    this.setQuaternion(this.rightFoot, this.rightFootCurrentOrient, this.frontFootPassingOrient, portion);
                    this.setQuaternion(this.leftUpper, this.leftUpperCurrentOrient, this.backUpperPassingOrient, portion);
                    this.setQuaternion(this.leftLower, this.leftLowerCurrentOrient, this.backLowerPassingOrient, portion);
                    this.setQuaternion(this.leftFoot, this.leftFootCurrentOrient, this.backFootPassingOrient, portion);
                } else {
                    this.setQuaternion(this.leftUpper, this.leftUpperCurrentOrient, this.frontUpperPassingOrient, portion);
                    this.setQuaternion(this.leftLower, this.leftLowerCurrentOrient, this.frontLowerPassingOrient, portion);
                    this.setQuaternion(this.leftFoot, this.leftFootCurrentOrient, this.frontFootPassingOrient, portion);
                    this.setQuaternion(this.rightUpper, this.rightUpperCurrentOrient, this.backUpperPassingOrient, portion);
                    this.setQuaternion(this.rightLower, this.rightLowerCurrentOrient, this.backLowerPassingOrient, portion);
                    this.setQuaternion(this.rightFoot, this.rightFootCurrentOrient, this.backFootPassingOrient, portion);
                }
            }
        }

        public void updateHighPoint(Transformable leg, double portion, boolean lastStep) {
            if (leg != null && portion <= 1.0) {
                if (lastStep) {
                    if (leg.equals(this.rightUpper)) {
                        this.setQuaternion(this.rightUpper, this.rightUpperCurrentOrient, this.defaultOrient, portion);
                        this.setQuaternion(this.rightLower, this.rightLowerCurrentOrient, this.defaultOrient, portion);
                        this.setQuaternion(this.rightFoot, this.rightFootCurrentOrient, this.defaultOrient, portion);
                        this.setQuaternion(this.leftUpper, this.leftUpperCurrentOrient, this.defaultOrient, portion);
                        this.setQuaternion(this.leftLower, this.leftLowerCurrentOrient, this.defaultOrient, portion);
                    } else {
                        this.setQuaternion(this.leftUpper, this.leftUpperCurrentOrient, this.defaultOrient, portion);
                        this.setQuaternion(this.leftLower, this.leftLowerCurrentOrient, this.defaultOrient, portion);
                        this.setQuaternion(this.leftFoot, this.leftFootCurrentOrient, this.defaultOrient, portion);
                        this.setQuaternion(this.rightUpper, this.rightUpperCurrentOrient, this.defaultOrient, portion);
                        this.setQuaternion(this.rightLower, this.rightLowerCurrentOrient, this.defaultOrient, portion);
                    }
                } else if (leg.equals(this.rightUpper)) {
                    this.setQuaternion(this.rightUpper, this.rightUpperCurrentOrient, this.frontUpperHighPointOrient, portion);
                    this.setQuaternion(this.rightLower, this.rightLowerCurrentOrient, this.frontLowerHighPointOrient, portion);
                    this.setQuaternion(this.rightFoot, this.rightFootCurrentOrient, this.frontFootHighPointOrient, portion);
                    this.setQuaternion(this.leftUpper, this.leftUpperCurrentOrient, this.backUpperHighPointOrient, portion);
                    this.setQuaternion(this.leftLower, this.leftLowerCurrentOrient, this.backLowerHighPointOrient, portion);
                } else {
                    this.setQuaternion(this.leftUpper, this.leftUpperCurrentOrient, this.frontUpperHighPointOrient, portion);
                    this.setQuaternion(this.leftLower, this.leftLowerCurrentOrient, this.frontLowerHighPointOrient, portion);
                    this.setQuaternion(this.leftFoot, this.leftFootCurrentOrient, this.frontFootHighPointOrient, portion);
                    this.setQuaternion(this.rightUpper, this.rightUpperCurrentOrient, this.backUpperHighPointOrient, portion);
                    this.setQuaternion(this.rightLower, this.rightLowerCurrentOrient, this.backLowerHighPointOrient, portion);
                }
            }
        }

        public void updateArms(Transformable leg, double portion, boolean lastStep) {
            if (lastStep && leg != null) {
                this.setQuaternion(this.leftUpperArm, this.leftUpperArmCurrentOrient, this.defaultOrient, portion);
                this.setQuaternion(this.leftLowerArm, this.leftLowerArmCurrentOrient, this.defaultOrient, portion);
                this.setQuaternion(this.rightUpperArm, this.rightUpperArmCurrentOrient, this.defaultOrient, portion);
                this.setQuaternion(this.rightLowerArm, this.rightLowerArmCurrentOrient, this.defaultOrient, portion);
            } else if (leg != null) {
                if (leg.equals(this.leftUpper)) {
                    this.setQuaternion(this.rightUpperArm, this.rightUpperArmCurrentOrient, this.frontUpperArmOrient, portion);
                    this.setQuaternion(this.rightLowerArm, this.rightLowerArmCurrentOrient, this.frontLowerArmOrient, portion);
                    this.setQuaternion(this.leftUpperArm, this.leftUpperArmCurrentOrient, this.backUpperArmOrient, portion);
                    this.setQuaternion(this.leftLowerArm, this.leftLowerArmCurrentOrient, this.backLowerArmOrient, portion);
                } else {
                    this.setQuaternion(this.leftUpperArm, this.leftUpperArmCurrentOrient, this.frontUpperArmOrient, portion);
                    this.setQuaternion(this.leftLowerArm, this.leftLowerArmCurrentOrient, this.frontLowerArmOrient, portion);
                    this.setQuaternion(this.rightUpperArm, this.rightUpperArmCurrentOrient, this.backUpperArmOrient, portion);
                    this.setQuaternion(this.rightLowerArm, this.rightLowerArmCurrentOrient, this.backLowerArmOrient, portion);
                }
            }
        }

        @Override
        public void epilogue(double t) {
            super.epilogue(t);
            if (this.leftUpper != null) {
                if (AbstractWalkAnimation.this.swingArms.getValue().equals(Boolean.TRUE)) {
                    this.setQuaternion(this.leftUpperArm, this.leftUpperArmCurrentOrient, this.defaultOrient, 1.0);
                    this.setQuaternion(this.leftLowerArm, this.leftLowerArmCurrentOrient, this.defaultOrient, 1.0);
                    this.setQuaternion(this.rightUpperArm, this.rightUpperArmCurrentOrient, this.defaultOrient, 1.0);
                    this.setQuaternion(this.rightLowerArm, this.rightLowerArmCurrentOrient, this.defaultOrient, 1.0);
                }
                this.setQuaternion(this.rightUpper, this.rightUpperCurrentOrient, this.defaultOrient, 1.0);
                this.setQuaternion(this.rightLower, this.rightLowerCurrentOrient, this.defaultOrient, 1.0);
                this.setQuaternion(this.rightFoot, this.rightFootCurrentOrient, this.defaultOrient, 1.0);
                this.setQuaternion(this.leftUpper, this.leftUpperCurrentOrient, this.defaultOrient, 1.0);
                this.setQuaternion(this.leftLower, this.leftLowerCurrentOrient, this.defaultOrient, 1.0);
                this.setQuaternion(this.rightFoot, this.rightFootCurrentOrient, this.defaultOrient, 1.0);
            }
            this.adjustHeight();
        }

        private void setQuaternion(Transformable part, Matrix33 initialOrient, Matrix33 finalOrient, double portion) {
            double positionPortion = this.m_style.getPortion(portion, 1.0);
            Matrix33 currentOrient = Matrix33.interpolate(initialOrient, finalOrient, positionPortion);
            if (part != null) {
                part.setOrientationRightNow(currentOrient);
            }
        }
    }
}

