/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.criterion.ElementNameContainsCriterion;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.response.StandUpAnimation;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Vector3;
import java.util.Vector;
import javax.vecmath.Vector3d;

public class BetterStandUpAnimation
extends StandUpAnimation {
    public final BooleanProperty scootForward = new BooleanProperty(this, "scoot forward", Boolean.TRUE);

    public class RuntimeBetterStandUpAnimation
    extends StandUpAnimation.RuntimeStandUpAnimation {
        Vector bodyPartInitialOrientations = null;
        Vector bodyParts = null;
        Matrix33 normalOrientation = new Matrix33();
        private Vector3d m_positionBegin;
        private Vector3d m_positionEnd;

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.bodyPartInitialOrientations = new Vector();
            this.bodyParts = new Vector();
            this.normalOrientation.setForwardUpGuide(new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 1.0, 0.0));
            this.m_positionBegin = this.m_subject.getPosition(this.m_subject.getWorld());
            if (this.m_subject != null) {
                this.findChildren(this.m_subject);
            }
        }

        protected Vector3d getPositionEnd() {
            if (this.m_subject != null) {
                int level = (int)Math.round(this.m_positionBegin.y / 256.0);
                Vector3 forward = this.getTargetQuaternion().getMatrix33().getRow(2);
                double moveAmount = 0.0;
                Element[] legs = this.m_subject.search(new ElementNameContainsCriterion("UpperLeg"));
                if (legs.length > 0) {
                    Model upperLeg = (Model)legs[0];
                    moveAmount = upperLeg.getBoundingBox(upperLeg).getHeight();
                }
                this.m_positionEnd = BetterStandUpAnimation.this.scootForward.booleanValue() ? new Vector3d(this.m_positionBegin.x + forward.x * moveAmount, 256.0 * (double)level, this.m_positionBegin.z + forward.z * moveAmount) : new Vector3d(this.m_positionBegin.x, 256.0 * (double)level, this.m_positionBegin.z);
                return this.m_positionEnd;
            }
            return this.m_positionBegin;
        }

        @Override
        public void update(double t) {
            int i = 0;
            while (i < this.bodyPartInitialOrientations.size()) {
                this.setOrientation((Transformable)this.bodyParts.elementAt(i), (Matrix33)this.bodyPartInitialOrientations.elementAt(i), this.normalOrientation, this.getPortion(t));
                ++i;
            }
            if (this.m_positionEnd == null) {
                this.m_positionEnd = this.getPositionEnd();
            }
            this.m_subject.setPositionRightNow(MathUtilities.interpolate(this.m_positionBegin, this.m_positionEnd, this.getPortion(t)), ReferenceFrame.ABSOLUTE);
            this.adjustHeight();
            super.update(t);
        }

        @Override
        public void epilogue(double t) {
            super.epilogue(t);
            this.m_positionEnd = null;
        }

        private void findChildren(Transformable part) {
            Element[] kids = part.getChildren(Transformable.class);
            int i = 0;
            while (i < kids.length) {
                Transformable trans = (Transformable)kids[i];
                this.bodyPartInitialOrientations.addElement(trans.getOrientationAsAxes((ReferenceFrame)trans.getParent()));
                this.bodyParts.addElement(trans);
                if (trans.getChildCount() > 0) {
                    this.findChildren(trans);
                }
                ++i;
            }
        }

        protected void adjustHeight() {
            double distanceAboveGround = 0.0;
            if (this.m_subject != null) {
                distanceAboveGround = this.m_subject.getBoundingBox((ReferenceFrame)this.m_subject.getWorld()).getCenterOfBottomFace().y;
                double roundHeight = Math.round(this.m_subject.getBoundingBox((ReferenceFrame)this.m_subject.getWorld()).getCenterOfBottomFace().y);
                int level = (int)Math.round(roundHeight / 256.0);
                this.m_subject.moveRightNow(Direction.DOWN, distanceAboveGround - 256.0 * (double)level, this.m_subject.getWorld());
            }
        }

        private void setOrientation(Transformable part, Matrix33 initialOrient, Matrix33 finalOrient, double portion) {
            Matrix33 currentOrient = Matrix33.interpolate(initialOrient, finalOrient, portion);
            if (part != null) {
                part.setOrientationRightNow(currentOrient, (ReferenceFrame)part.getParent());
            }
        }
    }
}

