/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.event.ExpressionEvent;
import edu.cmu.cs.stage3.alice.core.event.ExpressionListener;
import edu.cmu.cs.stage3.alice.core.property.DirectionProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.response.TransformResponse;
import edu.cmu.cs.stage3.lang.Messages;

public abstract class DirectionSpeedTransformResponse
extends TransformResponse {
    public final DirectionProperty direction = new DirectionProperty(this, "direction", this.getDefaultDirection());
    public final NumberProperty speed = new NumberProperty(this, "speed", new Double(1.0));

    protected abstract Direction getDefaultDirection();

    protected abstract boolean acceptsDirection(Direction var1);

    @Override
    protected void propertyChanging(Property property, Object value) {
        if (property == this.direction) {
            if (value instanceof Direction && !this.acceptsDirection((Direction)value)) {
                throw new RuntimeException(this + " " + Messages.getString("does_not_accept_direction_") + value);
            }
        } else {
            super.propertyChanging(property, value);
        }
    }

    public class RuntimeDirectionSpeedTransformResponse
    extends TransformResponse.RuntimeTransformResponse
    implements ExpressionListener {
        private double m_speed;
        private boolean m_isSpeedDirty;
        private Expression m_expression;

        public RuntimeDirectionSpeedTransformResponse() {
            super(DirectionSpeedTransformResponse.this);
            this.m_speed = Double.NaN;
            this.m_isSpeedDirty = true;
            this.m_expression = null;
        }

        protected double getSpeed() {
            if (this.m_isSpeedDirty) {
                this.m_speed = DirectionSpeedTransformResponse.this.speed.doubleValue();
            }
            return this.m_speed;
        }

        @Override
        public void expressionChanged(ExpressionEvent expressionEvent) {
            this.m_isSpeedDirty = true;
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            if (DirectionSpeedTransformResponse.this.direction.getDirectionValue() == null) {
                throw new SimulationPropertyException(Messages.getString("direction_value_must_not_be_null_"), null, DirectionSpeedTransformResponse.this.direction);
            }
            if (DirectionSpeedTransformResponse.this.speed.getValue() == null) {
                throw new SimulationPropertyException(Messages.getString("speed_value_must_not_be_null_"), null, DirectionSpeedTransformResponse.this.speed);
            }
            Object o = DirectionSpeedTransformResponse.this.speed.get();
            if (o instanceof Expression) {
                this.m_expression = (Expression)o;
                this.m_expression.addExpressionListener(this);
            } else {
                this.m_expression = null;
            }
        }

        @Override
        public void epilogue(double t) {
            super.epilogue(t);
            if (this.m_expression != null) {
                this.m_expression.removeExpressionListener(this);
                this.m_expression = null;
            }
        }
    }
}

