/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.alice.core.response.DoInOrder;

public class DoTogether
extends CompositeResponse {
    private static Class[] s_supportedCoercionClasses = new Class[]{DoInOrder.class};

    @Override
    public Class[] getSupportedCoercionClasses() {
        return s_supportedCoercionClasses;
    }

    public class RuntimeDoTogether
    extends CompositeResponse.RuntimeCompositeResponse {
        private double m_timeRemaining;
        private Behavior m_currentBehavior;

        public RuntimeDoTogether() {
            super(DoTogether.this);
            this.m_currentBehavior = null;
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            Response.RuntimeResponse[] runtimeResponses = this.getRuntimeResponses();
            if (runtimeResponses.length > 0) {
                Sandbox sandbox;
                World world = DoTogether.this.getWorld();
                if (world != null && (sandbox = world.getCurrentSandbox()) != null) {
                    this.m_currentBehavior = sandbox.getCurrentBehavior();
                    this.m_currentBehavior.openFork(this, runtimeResponses.length);
                }
            } else {
                this.m_currentBehavior = null;
            }
            int i = 0;
            while (i < runtimeResponses.length) {
                if (this.m_currentBehavior != null) {
                    this.m_currentBehavior.setForkIndex(this, i);
                }
                runtimeResponses[i].prologue(t);
                ++i;
            }
            if (this.m_currentBehavior != null) {
                this.m_currentBehavior.setForkIndex(this, -1);
            }
        }

        @Override
        public void update(double t) {
            super.update(t);
            Response.RuntimeResponse[] runtimeResponses = this.getRuntimeResponses();
            this.m_timeRemaining = -this.getTimeElapsed(t);
            int i = 0;
            while (i < runtimeResponses.length) {
                if (this.m_currentBehavior != null) {
                    this.m_currentBehavior.setForkIndex(this, i);
                }
                if (runtimeResponses[i].isActive()) {
                    runtimeResponses[i].update(t);
                    double timeRemaining = runtimeResponses[i].getTimeRemaining(t);
                    if (timeRemaining <= 0.0) {
                        runtimeResponses[i].epilogue(t);
                    }
                    this.m_timeRemaining = Math.max(timeRemaining, this.m_timeRemaining);
                }
                ++i;
            }
            if (this.m_currentBehavior != null) {
                this.m_currentBehavior.setForkIndex(this, -1);
            }
        }

        @Override
        public void epilogue(double t) {
            super.epilogue(t);
            if (this.m_currentBehavior != null) {
                this.m_currentBehavior.setForkIndex(this, 0);
                this.m_currentBehavior.closeFork(this);
                this.m_currentBehavior = null;
            }
        }

        @Override
        public double getTimeRemaining(double t) {
            return this.m_timeRemaining;
        }
    }
}

