/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.property.DirectionProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import edu.cmu.cs.stage3.alice.core.response.BetterStandUpAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Vector3d;

public class LieDownAnimation
extends BetterStandUpAnimation {
    public final TransformableProperty target = new TransformableProperty((Element)this, "target", null);
    public final DirectionProperty feetFaceDirection = new DirectionProperty(this, "feetFacingDirection", Direction.FORWARD);

    public class RuntimeLieDownAnimation
    extends BetterStandUpAnimation.RuntimeBetterStandUpAnimation {
        Transformable target;
        private Vector3d m_positionBegin;
        private Vector3d m_positionEnd;
        private Direction m_direction;

        public RuntimeLieDownAnimation() {
            super(LieDownAnimation.this);
            this.target = null;
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.target = LieDownAnimation.this.target.getTransformableValue();
            if (this.target == null) {
                throw new SimulationPropertyException(String.valueOf(this.m_subject.name.getStringValue()) + " " + Messages.getString("needs_something_or_someone_to_lie_down_on_"), null, LieDownAnimation.this.target);
            }
            if (this.m_subject == this.target) {
                throw new SimulationPropertyException(String.valueOf(this.m_subject.name.getStringValue()) + " " + Messages.getString("can_t_lie_down_on_") + this.target.name.getStringValue() + ".", this.getCurrentStack(), LieDownAnimation.this.target);
            }
            if (this.m_subject.isAncestorOf(this.target)) {
                throw new SimulationPropertyException(String.valueOf(this.m_subject.name.getStringValue()) + Messages.getString("can_t_lie_down_on_a_part_of_itself"), this.getCurrentStack(), LieDownAnimation.this.target);
            }
            this.m_positionBegin = this.m_subject.getPosition(this.m_subject.getWorld());
            this.m_direction = LieDownAnimation.this.feetFaceDirection.getDirectionValue();
        }

        @Override
        public void update(double t) {
            super.update(t);
            if (this.m_positionEnd == null) {
                this.m_positionEnd = this.getPositionEnd();
            }
            this.m_subject.setPositionRightNow(MathUtilities.interpolate(this.m_positionBegin, this.m_positionEnd, this.getPortion(t)), ReferenceFrame.ABSOLUTE);
        }

        @Override
        public void epilogue(double t) {
            super.epilogue(t);
            this.m_positionEnd = null;
        }

        @Override
        protected Vector3d getPositionEnd() {
            if (this.target != null) {
                Vector3d endPos = null;
                endPos = this.target.name.getStringValue().equals("ground") ? this.m_subject.getBoundingBox(this.m_subject.getWorld()).getCenterOfBottomFace() : this.target.getBoundingBox(this.target.getWorld()).getCenterOfTopFace();
                Vector3[] forwardAndUp = this.target.getOrientationAsForwardAndUpGuide(this.target.getWorld());
                Vector3d left = new Vector3d();
                left.cross((Vector3d)forwardAndUp[0], (Vector3d)forwardAndUp[1]);
                double subjectHeight = this.m_subject.getHeight();
                double zOffset = Math.abs(this.m_subject.getBoundingBox((ReferenceFrame)this.m_subject).getCenterOfBackFace().z) - this.m_subject.getBoundingBox(this.m_subject).getDepth() * 0.2;
                if (this.m_direction.equals(Direction.BACKWARD)) {
                    endPos = new Vector3d(endPos.x - forwardAndUp[0].x * subjectHeight / 2.0, endPos.y + zOffset + forwardAndUp[0].y * subjectHeight / 2.0, endPos.z - forwardAndUp[0].z * subjectHeight / 2.0);
                } else if (this.m_direction.equals(Direction.FORWARD)) {
                    endPos = new Vector3d(endPos.x + forwardAndUp[0].x * subjectHeight / 2.0, endPos.y + zOffset + forwardAndUp[0].y * subjectHeight / 2.0, endPos.z + forwardAndUp[0].z * subjectHeight / 2.0);
                } else if (this.m_direction.equals(Direction.LEFT)) {
                    endPos = new Vector3d(endPos.x - left.x * subjectHeight / 2.0, endPos.y + zOffset + left.y * subjectHeight / 2.0, endPos.z - left.z * subjectHeight / 2.0);
                } else if (this.m_direction.equals(Direction.RIGHT)) {
                    endPos = new Vector3d(endPos.x + left.x * subjectHeight / 2.0, endPos.y + zOffset + left.y * subjectHeight / 2.0, endPos.z + left.z * subjectHeight / 2.0);
                }
                return endPos;
            }
            return this.m_positionBegin;
        }

        protected Matrix33 getGoalOrientation(Matrix33 targetsOrient, Vector3 goalForward) {
            Matrix33 orient = new Matrix33();
            Vector3 goalUp = null;
            if (this.m_direction.equals(Direction.FORWARD) || this.m_direction.equals(Direction.BACKWARD)) {
                goalUp = targetsOrient.getRow(2);
                if (this.m_direction.equals(Direction.FORWARD)) {
                    goalUp.negate();
                }
            } else {
                goalUp = targetsOrient.getRow(0);
                if (this.m_direction.equals(Direction.LEFT)) {
                    goalUp.negate();
                }
            }
            orient.setForwardUpGuide(goalForward, goalUp);
            return orient;
        }

        @Override
        protected Quaternion getTargetQuaternion() {
            Quaternion quat = this.m_subject.calculateStandUp(this.m_subject.getWorld()).getQuaternion();
            if (this.target == null || this.target.name.getStringValue().equals("ground")) {
                Matrix33 orient = quat.getMatrix33();
                quat.setMatrix33(this.getGoalOrientation(orient, quat.getMatrix33().getRow(1)));
            } else {
                Matrix33 orientSubject = quat.getMatrix33();
                Matrix33 orientTarget = this.target.getOrientationAsAxes(this.target.getWorld());
                quat.setMatrix33(this.getGoalOrientation(orientTarget, quat.getMatrix33().getRow(1)));
            }
            return quat;
        }

        @Override
        protected void adjustHeight() {
            if (this.target == null) {
                super.adjustHeight();
            } else {
                double distanceAboveTarget = 0.0;
                if (this.m_subject != null) {
                    distanceAboveTarget = this.m_subject.getBoundingBox((ReferenceFrame)this.m_subject.getWorld()).getCenterOfBottomFace().y;
                    this.m_subject.moveRightNow(Direction.DOWN, distanceAboveTarget -= this.target.getBoundingBox((ReferenceFrame)this.m_subject.getWorld()).getCenterOfTopFace().y, this.m_subject.getWorld());
                }
            }
        }
    }
}

